/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.strategy.impl;

import cn.hutool.core.util.StrUtil;
import com.cssw.bootx.storage.autoconfigure.properties.OssStorageProperties;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.common.util.StorageUtils;
import com.cssw.bootx.storage.domain.model.resp.FileInfo;
import com.cssw.bootx.storage.domain.model.resp.MultipartInitResp;
import com.cssw.bootx.storage.domain.model.resp.MultipartUploadResp;
import com.cssw.bootx.storage.strategy.StorageStrategy;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

public class OssStorageStrategy
implements StorageStrategy {
    private static final Logger log = LoggerFactory.getLogger(OssStorageStrategy.class);
    private final S3Client s3Client;
    private final S3Presigner s3Presigner;
    private final OssStorageProperties config;

    public OssStorageStrategy(OssStorageProperties config) {
        this.config = config;
        this.s3Client = this.createS3Client(config);
        this.s3Presigner = this.createS3Presigner(config);
    }

    public S3Client getClient() {
        return this.s3Client;
    }

    public S3Presigner getPresigner() {
        return this.s3Presigner;
    }

    private S3Client createS3Client(OssStorageProperties config) {
        StaticCredentialsProvider auth = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)config.getAccessKey(), (String)config.getSecretKey()));
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)auth)).endpointOverride(URI.create(config.getEndpoint()))).region(StorageUtils.getRegion(config.getRegion()))).build();
    }

    private S3Presigner createS3Presigner(OssStorageProperties config) {
        StaticCredentialsProvider auth = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)config.getAccessKey(), (String)config.getSecretKey()));
        String domain = StrUtil.isNotBlank((CharSequence)config.getDomain()) ? config.getDomain() : config.getEndpoint();
        return S3Presigner.builder().credentialsProvider((AwsCredentialsProvider)auth).endpointOverride(URI.create(domain)).region(StorageUtils.getRegion(config.getRegion())).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(config.isPathStyleAccessEnabled())).build()).build();
    }

    @Override
    public void upload(String bucket, String path, MultipartFile file) {
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(bucket).key(path).contentType(file.getContentType()).contentLength(Long.valueOf(file.getSize()));
        try {
            this.s3Client.putObject((PutObjectRequest)requestBuilder.build(), RequestBody.fromInputStream((InputStream)file.getInputStream(), (long)file.getSize()));
        }
        catch (Exception e) {
            throw new StorageException("S3\u4e0a\u4f20\u5f02\u5e38" + e.getMessage(), e);
        }
    }

    @Override
    public InputStream download(String bucket, String path) {
        try {
            return this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(path).build());
        }
        catch (Exception e) {
            throw new StorageException("S3\u4e0b\u8f7d\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream batchDownload(String bucket, List<String> paths) {
        return null;
    }

    @Override
    public void delete(String bucket, String path) {
        try {
            this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(path).build());
        }
        catch (Exception e) {
            throw new StorageException("S3\u5220\u9664\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void batchDelete(String bucket, List<String> paths) {
        if (paths.isEmpty()) {
            return;
        }
        try {
            List<List<String>> batches = this.partition(paths, 1000);
            for (List<String> batch : batches) {
                List objects = batch.stream().map(path -> (ObjectIdentifier)ObjectIdentifier.builder().key(path).build()).collect(Collectors.toList());
                DeleteObjectsRequest deleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects(objects).build()).build();
                this.s3Client.deleteObjects(deleteRequest);
            }
        }
        catch (Exception e) {
            throw new StorageException("S3\u6279\u91cf\u5220\u9664\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean exists(String bucket, String path) {
        try {
            this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(path).build());
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
        catch (Exception e) {
            throw new StorageException("S3\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u6027\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public FileInfo getFileInfo(String bucket, String path) {
        try {
            String bucketName = bucket;
            HeadObjectResponse response = this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(path).build());
            FileInfo fileInfo = new FileInfo();
            fileInfo.setBucket(bucketName);
            fileInfo.setPlatform(this.config.getPlatform());
            fileInfo.setPath(path);
            fileInfo.setFullPath(path);
            fileInfo.setName(this.getFileName(path));
            fileInfo.setSize(response.contentLength());
            fileInfo.setContentType(response.contentType());
            fileInfo.setUrl(this.getFileUrl(path));
            fileInfo.setUploadTime(LocalDateTime.ofInstant(response.lastModified(), ZoneId.systemDefault()));
            HashMap<String, String> metadata = new HashMap<String, String>(response.metadata());
            metadata.put("etag", response.eTag());
            if (response.versionId() != null) {
                metadata.put("versionId", response.versionId());
            }
            fileInfo.setMetadata(metadata);
            return fileInfo;
        }
        catch (NoSuchKeyException e) {
            return null;
        }
        catch (Exception e) {
            throw new StorageException("S3\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public List<FileInfo> list(String bucket, String prefix, int maxKeys) {
        try {
            String bucketName = bucket;
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix).maxKeys(Integer.valueOf(maxKeys)).build();
            ListObjectsV2Response response = this.s3Client.listObjectsV2(request);
            return response.contents().stream().map(s3Object -> {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setBucket(bucketName);
                fileInfo.setPlatform(this.config.getPlatform());
                fileInfo.setPath(s3Object.key());
                fileInfo.setFullPath(s3Object.key());
                fileInfo.setName(this.getFileName(s3Object.key()));
                fileInfo.setSize(s3Object.size());
                fileInfo.setUrl(this.getFileUrl(s3Object.key()));
                fileInfo.setUploadTime(LocalDateTime.ofInstant(s3Object.lastModified(), ZoneId.systemDefault()));
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("etag", s3Object.eTag());
                metadata.put("storageClass", s3Object.storageClassAsString());
                fileInfo.setMetadata(metadata);
                return fileInfo;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new StorageException("S3\u5217\u51fa\u6587\u4ef6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void copy(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        try {
            CopyObjectRequest copyRequest = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(sourceBucket).sourceKey(sourcePath).destinationBucket(targetBucket).destinationKey(targetPath).build();
            this.s3Client.copyObject(copyRequest);
        }
        catch (Exception e) {
            throw new StorageException("S3\u590d\u5236\u6587\u4ef6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void move(String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
    }

    @Override
    public String getPlatform() {
        return this.config.getPlatform();
    }

    @Override
    public String defaultBucket() {
        return this.config.getBucketName();
    }

    @Override
    public String generatePresignedUrl(String bucket, String path, long expireSeconds) {
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(path).build();
            GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(expireSeconds)).getObjectRequest(getObjectRequest).build();
            PresignedGetObjectRequest presignedRequest = this.s3Presigner.presignGetObject(presignRequest);
            return presignedRequest.url().toString();
        }
        catch (Exception e) {
            throw new StorageException("S3\u751f\u6210\u9884\u7b7e\u540dURL\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private String getFileUrl(String path) {
        if (this.config.getEndpoint() != null && !this.config.getEndpoint().isEmpty()) {
            return this.config.getEndpoint() + "/" + path;
        }
        return String.format("%s/%s/%s", this.config.getEndpoint(), this.config.getBucketName(), path);
    }

    private String getFileName(String path) {
        int lastSlashIndex = path.lastIndexOf("/");
        return lastSlashIndex >= 0 ? path.substring(lastSlashIndex + 1) : path;
    }

    private <T> List<List<T>> partition(List<T> list, int size) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += size) {
            partitions.add(list.subList(i, Math.min(i + size, list.size())));
        }
        return partitions;
    }

    @Override
    public MultipartInitResp initMultipartUpload(String bucket, String path, String contentType, Map<String, String> metadata) {
        try {
            CreateMultipartUploadRequest.Builder requestBuilder = CreateMultipartUploadRequest.builder().bucket(bucket).key(path).contentType(contentType);
            if (metadata != null && !metadata.isEmpty()) {
                requestBuilder.metadata(metadata);
            }
            if (this.config.getDefaultAcl() != null) {
                requestBuilder.acl(this.config.getDefaultAcl());
            }
            CreateMultipartUploadResponse response = this.s3Client.createMultipartUpload((CreateMultipartUploadRequest)requestBuilder.build());
            MultipartInitResp result = new MultipartInitResp();
            result.setBucket(bucket);
            result.setFileId(UUID.randomUUID().toString());
            result.setUploadId(response.uploadId());
            result.setPlatform(this.config.getPlatform());
            result.setPath(path);
            result.setPartSize(this.config.getMultipartUploadPartSize());
            return result;
        }
        catch (Exception e) {
            throw new StorageException("S3\u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public MultipartUploadResp uploadPart(String bucket, String path, String uploadId, int partNumber, InputStream data) {
        try {
            if (path == null) {
                throw new StorageException("\u65e0\u6548\u7684uploadId: " + uploadId);
            }
            byte[] bytes = data.readAllBytes();
            UploadPartRequest request = (UploadPartRequest)UploadPartRequest.builder().bucket(bucket).key(path).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).contentLength(Long.valueOf(bytes.length)).build();
            UploadPartResponse response = this.s3Client.uploadPart(request, RequestBody.fromBytes((byte[])bytes));
            MultipartUploadResp result = new MultipartUploadResp();
            result.setPartNumber(partNumber);
            result.setPartETag(response.eTag());
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            MultipartUploadResp result = new MultipartUploadResp();
            result.setPartNumber(partNumber);
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public FileInfo completeMultipartUpload(String bucket, String path, String uploadId, List<MultipartUploadResp> parts, boolean verifyParts) {
        try {
            if (path == null) {
                throw new StorageException("\u65e0\u6548\u7684uploadId: " + uploadId);
            }
            if (verifyParts) {
                List<MultipartUploadResp> s3Parts = this.listParts(bucket, path, uploadId);
                this.validateParts(parts, s3Parts);
            }
            List completedParts = parts.stream().filter(MultipartUploadResp::isSuccess).map(part -> (CompletedPart)CompletedPart.builder().partNumber(part.getPartNumber()).eTag(part.getPartETag()).build()).sorted(Comparator.comparingInt(CompletedPart::partNumber)).collect(Collectors.toList());
            CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucket).key(path).uploadId(uploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build();
            this.s3Client.completeMultipartUpload(request);
            return this.getFileInfo(bucket, path);
        }
        catch (Exception e) {
            throw new StorageException("S3\u5b8c\u6210\u5206\u7247\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void abortMultipartUpload(String bucket, String path, String uploadId) {
        try {
            if (path == null) {
                log.warn("\u65e0\u6548\u7684uploadId\uff0c\u53ef\u80fd\u5df2\u7ecf\u5b8c\u6210\u6216\u53d6\u6d88: {}", (Object)uploadId);
                return;
            }
            AbortMultipartUploadRequest request = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(bucket).key(path).uploadId(uploadId).build();
            this.s3Client.abortMultipartUpload(request);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5206\u7247\u4e0a\u4f20\u5931\u8d25: uploadId={}", (Object)uploadId, (Object)e);
            throw new StorageException("S3\u53d6\u6d88\u5206\u7247\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public List<MultipartUploadResp> listParts(String bucket, String path, String uploadId) {
        try {
            if (path == null) {
                throw new StorageException("\u65e0\u6548\u7684uploadId: " + uploadId);
            }
            ListPartsRequest request = (ListPartsRequest)ListPartsRequest.builder().bucket(bucket).key(path).uploadId(uploadId).build();
            ListPartsResponse response = this.s3Client.listParts(request);
            return response.parts().stream().map(part -> {
                MultipartUploadResp result = new MultipartUploadResp();
                result.setPartNumber(part.partNumber());
                result.setPartETag(part.eTag());
                result.setSuccess(true);
                return result;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new StorageException("S3\u5217\u51fa\u5206\u7247\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void validateParts(List<MultipartUploadResp> recordParts, List<MultipartUploadResp> s3Parts) {
        Map<Integer, String> recordMap = recordParts.stream().collect(Collectors.toMap(MultipartUploadResp::getPartNumber, MultipartUploadResp::getPartETag));
        Map<Integer, String> s3Map = s3Parts.stream().collect(Collectors.toMap(MultipartUploadResp::getPartNumber, MultipartUploadResp::getPartETag));
        if (recordMap.size() != s3Map.size()) {
            throw new StorageException(String.format("\u5206\u7247\u6570\u91cf\u4e0d\u4e00\u81f4: \u672c\u5730\u8bb0\u5f55=%d, S3=%d", recordMap.size(), s3Map.size()));
        }
        ArrayList<Integer> missingParts = new ArrayList<Integer>();
        ArrayList<Integer> mismatchParts = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : recordMap.entrySet()) {
            Integer partNumber = entry.getKey();
            String recordETag = entry.getValue();
            String s3ETag = s3Map.get(partNumber);
            if (s3ETag == null) {
                missingParts.add(partNumber);
                continue;
            }
            if (recordETag.equals(s3ETag)) continue;
            mismatchParts.add(partNumber);
        }
        if (!missingParts.isEmpty()) {
            throw new StorageException("S3\u7f3a\u5931\u5206\u7247: " + missingParts);
        }
        if (!mismatchParts.isEmpty()) {
            throw new StorageException("\u5206\u7247ETag\u4e0d\u5339\u914d: " + mismatchParts);
        }
    }
}

