/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.validation.constraints;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.core.enums.BaseEnum;
import com.cssw.bootx.validation.constraints.EnumValue;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValueValidator
implements ConstraintValidator<EnumValue, Object> {
    private static final Logger log = LoggerFactory.getLogger(EnumValueValidator.class);
    private Class<? extends Enum> enumClass;
    private String[] enumValues;
    private String enumMethod;

    public void initialize(EnumValue enumValue) {
        this.enumClass = enumValue.value();
        this.enumValues = enumValue.enumValues();
        this.enumMethod = enumValue.method();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value.getClass().isArray()) {
            Object[] array;
            for (Object element : array = (Object[])value) {
                if (this.isValidElement(element)) continue;
                return false;
            }
            return true;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object element : iterable) {
                if (this.isValidElement(element)) continue;
                return false;
            }
            return true;
        }
        return this.isValidElement(value);
    }

    private boolean isValidElement(Object value) {
        if (this.enumValues.length > 0) {
            return Arrays.asList(this.enumValues).contains(Convert.toStr((Object)value));
        }
        Enum[] enumConstants = this.enumClass.getEnumConstants();
        if (enumConstants.length == 0) {
            return false;
        }
        if (CharSequenceUtil.isBlank((CharSequence)this.enumMethod)) {
            return this.findEnumValue(enumConstants, Convert.toStr((Object)value));
        }
        try {
            Method method = this.enumClass.getMethod(this.enumMethod, new Class[0]);
            for (Enum enumConstant : enumConstants) {
                if (!Convert.toStr((Object)method.invoke((Object)enumConstant, new Object[0])).equals(Convert.toStr((Object)value))) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while validating the enum value, please check the @EnumValue parameter configuration.", (Throwable)e);
        }
        return false;
    }

    private boolean findEnumValue(Enum[] enumConstants, Object value) {
        for (Enum enumConstant : enumConstants) {
            BaseEnum baseEnum;
            if (!(enumConstant instanceof BaseEnum ? (baseEnum = (BaseEnum)enumConstant).getValue().toString().equals(value) : enumConstant.toString().equals(value))) continue;
            return true;
        }
        return false;
    }
}

