package com.cssw.iotnet;

import lombok.Builder;
import lombok.Getter;

import static com.cssw.iotnet.IotnetConsts.*;

/**
 * @author Feng Chen
 */
@Getter
@Builder
public class IotnetClientOptions {

    /**
     * 服务地址
     */
    private String serverUrl;

    /**
     * 产品秘钥
     */
    private String productKey;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 设备秘钥
     */
    private String deviceSecret;

    /**
     * 连接超时(单位秒)
     */
    @Builder.Default
    private Integer connectTimeout = IOTNET_CONNECT_TIMEOUT;

    /**
     * 重连间隔(单位秒)
     */
    @Builder.Default
    private Integer reconnectInterval = IOTNET_RECONNECT_INTERVAL;

    /**
     * 保活(单位秒)
     */
    @Builder.Default
    private Integer keepAlive = IOTNET_KEEP_ALIVE;

}
