/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.http;

import com.cssw.kylin.http.AsyncCall;
import com.cssw.kylin.http.BaseAuthenticator;
import com.cssw.kylin.http.Exchange;
import com.cssw.kylin.http.FormBuilder;
import com.cssw.kylin.http.LogLevel;
import com.cssw.kylin.http.MultipartFormBuilder;
import com.cssw.kylin.http.ResponseSpec;
import com.cssw.kylin.http.RetryInterceptor;
import com.cssw.kylin.http.RetryPolicy;
import com.cssw.kylin.http.Slf4jLogger;
import com.cssw.kylin.tool.jackson.JsonUtil;
import com.cssw.kylin.tool.ssl.DisableValidationTrustManager;
import com.cssw.kylin.tool.ssl.TrustAllHostNames;
import com.cssw.kylin.tool.util.Exceptions;
import com.cssw.kylin.tool.util.Holder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.EventListener;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpRequest {
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36";
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json;charset=UTF-8");
    private static volatile OkHttpClient httpClient = new OkHttpClient();
    @Nullable
    private static HttpLoggingInterceptor globalLoggingInterceptor = null;
    private final Request.Builder requestBuilder;
    private final HttpUrl.Builder uriBuilder;
    private final String httpMethod;
    private String userAgent;
    @Nullable
    private RequestBody requestBody;
    @Nullable
    private Boolean followRedirects;
    @Nullable
    private Boolean followSslRedirects;
    @Nullable
    private HttpLoggingInterceptor.Level level;
    @Nullable
    private CookieJar cookieJar;
    @Nullable
    private EventListener eventListener;
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    @Nullable
    private Authenticator authenticator;
    @Nullable
    private Duration connectTimeout;
    @Nullable
    private Duration readTimeout;
    @Nullable
    private Duration writeTimeout;
    @Nullable
    private Proxy proxy;
    @Nullable
    private ProxySelector proxySelector;
    @Nullable
    private Authenticator proxyAuthenticator;
    @Nullable
    private RetryPolicy retryPolicy;
    @Nullable
    private Boolean disableSslValidation;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    @Nullable
    private X509TrustManager trustManager;

    public static HttpRequest get(String url) {
        return new HttpRequest(new Request.Builder(), url, "GET");
    }

    public static HttpRequest get(URI uri) {
        return HttpRequest.get(uri.toString());
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(new Request.Builder(), url, "POST");
    }

    public static HttpRequest post(URI uri) {
        return HttpRequest.post(uri.toString());
    }

    public static HttpRequest patch(String url) {
        return new HttpRequest(new Request.Builder(), url, "PATCH");
    }

    public static HttpRequest patch(URI uri) {
        return HttpRequest.patch(uri.toString());
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(new Request.Builder(), url, "PUT");
    }

    public static HttpRequest put(URI uri) {
        return HttpRequest.put(uri.toString());
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(new Request.Builder(), url, "DELETE");
    }

    public static HttpRequest delete(URI uri) {
        return HttpRequest.delete(uri.toString());
    }

    public HttpRequest query(String query) {
        this.uriBuilder.query(query);
        return this;
    }

    public HttpRequest queryEncoded(String encodedQuery) {
        this.uriBuilder.encodedQuery(encodedQuery);
        return this;
    }

    public HttpRequest queryMap(@Nullable Map<String, Object> queryMap) {
        if (queryMap != null && !queryMap.isEmpty()) {
            queryMap.forEach(this::query);
        }
        return this;
    }

    public HttpRequest query(String name, @Nullable Object value) {
        this.uriBuilder.addQueryParameter(name, value == null ? null : String.valueOf(value));
        return this;
    }

    public HttpRequest queryEncoded(String encodedName, @Nullable Object encodedValue) {
        this.uriBuilder.addEncodedQueryParameter(encodedName, encodedValue == null ? null : String.valueOf(encodedValue));
        return this;
    }

    HttpRequest form(FormBody formBody) {
        this.requestBody = formBody;
        return this;
    }

    HttpRequest multipartForm(MultipartBody multipartBody) {
        this.requestBody = multipartBody;
        return this;
    }

    public FormBuilder formBuilder() {
        return new FormBuilder(this);
    }

    public MultipartFormBuilder multipartFormBuilder() {
        return new MultipartFormBuilder(this);
    }

    public HttpRequest body(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public HttpRequest bodyString(String body) {
        this.requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)body);
        return this;
    }

    public HttpRequest bodyString(MediaType contentType, String body) {
        this.requestBody = RequestBody.create((MediaType)contentType, (String)body);
        return this;
    }

    public HttpRequest bodyJson(@Nonnull Object body) {
        return this.bodyString(JsonUtil.toJson((Object)body));
    }

    private HttpRequest(Request.Builder requestBuilder, String url, String httpMethod) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException(String.format("Url \u4e0d\u80fd\u89e3\u6790: %s: [%s]\u3002", httpMethod.toLowerCase(), url));
        }
        this.requestBuilder = requestBuilder;
        this.uriBuilder = httpUrl.newBuilder();
        this.httpMethod = httpMethod;
        this.userAgent = DEFAULT_USER_AGENT;
    }

    private Call internalCall(OkHttpClient client) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.readTimeout != null) {
            builder.readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.writeTimeout != null) {
            builder.writeTimeout(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
        }
        if (this.proxySelector != null) {
            builder.proxySelector(this.proxySelector);
        }
        if (this.proxyAuthenticator != null) {
            builder.proxyAuthenticator(this.proxyAuthenticator);
        }
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.sslSocketFactory != null && this.trustManager != null) {
            builder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
        }
        if (Boolean.TRUE.equals(this.disableSslValidation)) {
            HttpRequest.disableSslValidation(builder);
        }
        if (this.authenticator != null) {
            builder.authenticator(this.authenticator);
        }
        if (!this.interceptors.isEmpty()) {
            builder.interceptors().addAll(this.interceptors);
        }
        if (this.cookieJar != null) {
            builder.cookieJar(this.cookieJar);
        }
        if (this.eventListener != null) {
            builder.eventListener(this.eventListener);
        }
        if (this.followRedirects != null) {
            builder.followRedirects(this.followRedirects.booleanValue());
        }
        if (this.followSslRedirects != null) {
            builder.followSslRedirects(this.followSslRedirects.booleanValue());
        }
        if (this.retryPolicy != null) {
            builder.addInterceptor((Interceptor)new RetryInterceptor(this.retryPolicy));
        }
        if (this.level != null && HttpLoggingInterceptor.Level.NONE != this.level) {
            builder.addInterceptor((Interceptor)HttpRequest.getLoggingInterceptor(this.level));
        } else if (globalLoggingInterceptor != null) {
            builder.addInterceptor((Interceptor)globalLoggingInterceptor);
        }
        this.requestBuilder.header("User-Agent", this.userAgent);
        this.requestBuilder.url(this.uriBuilder.build());
        String method = this.httpMethod;
        Request request = HttpMethod.requiresRequestBody((String)method) && this.requestBody == null ? this.requestBuilder.method(method, Util.EMPTY_REQUEST).build() : this.requestBuilder.method(method, this.requestBody).build();
        return builder.build().newCall(request);
    }

    public Exchange execute() {
        return new Exchange(this.internalCall(httpClient));
    }

    public AsyncCall async() {
        return new AsyncCall(this.internalCall(httpClient));
    }

    public HttpRequest baseAuth(String userName, String password) {
        this.authenticator = new BaseAuthenticator(userName, password);
        return this;
    }

    public HttpRequest addHeader(Map<String, String> headers) {
        this.requestBuilder.headers(Headers.of(headers));
        return this;
    }

    public HttpRequest addHeader(String ... namesAndValues) {
        Headers headers = Headers.of((String[])namesAndValues);
        this.requestBuilder.headers(headers);
        return this;
    }

    public HttpRequest addHeader(String name, String value) {
        this.requestBuilder.addHeader(name, value);
        return this;
    }

    public HttpRequest setHeader(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    public HttpRequest removeHeader(String name) {
        this.requestBuilder.removeHeader(name);
        return this;
    }

    public HttpRequest addCookie(Cookie cookie) {
        this.addHeader("Cookie", cookie.toString());
        return this;
    }

    public HttpRequest cacheControl(CacheControl cacheControl) {
        this.requestBuilder.cacheControl(cacheControl);
        return this;
    }

    public HttpRequest userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest followSslRedirects(boolean followSslRedirects) {
        this.followSslRedirects = followSslRedirects;
        return this;
    }

    private static HttpLoggingInterceptor getLoggingInterceptor(HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(Slf4jLogger.INSTANCE);
        loggingInterceptor.setLevel(level);
        return loggingInterceptor;
    }

    public HttpRequest log() {
        this.level = HttpLoggingInterceptor.Level.BODY;
        return this;
    }

    public HttpRequest log(LogLevel logLevel) {
        this.level = logLevel.getLevel();
        return this;
    }

    public HttpRequest authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public HttpRequest interceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public HttpRequest cookieManager(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        return this;
    }

    public HttpRequest eventListener(EventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public HttpRequest connectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpRequest readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpRequest writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public HttpRequest proxy(InetSocketAddress address) {
        this.proxy = new Proxy(Proxy.Type.HTTP, address);
        return this;
    }

    public HttpRequest proxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public HttpRequest proxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        return this;
    }

    public HttpRequest retry() {
        this.retryPolicy = RetryPolicy.INSTANCE;
        return this;
    }

    public HttpRequest retryOn(Predicate<ResponseSpec> respPredicate) {
        this.retryPolicy = new RetryPolicy(respPredicate);
        return this;
    }

    public HttpRequest retry(int maxAttempts, long sleepMillis) {
        this.retryPolicy = new RetryPolicy(maxAttempts, sleepMillis);
        return this;
    }

    public HttpRequest retry(int maxAttempts, long sleepMillis, Predicate<ResponseSpec> respPredicate) {
        this.retryPolicy = new RetryPolicy(maxAttempts, sleepMillis);
        return this;
    }

    public HttpRequest disableSslValidation() {
        this.disableSslValidation = Boolean.TRUE;
        return this;
    }

    public HttpRequest hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
        return this;
    }

    public String toString() {
        return this.requestBuilder.toString();
    }

    public static void setHttpClient(OkHttpClient httpClient) {
        HttpRequest.httpClient = httpClient;
    }

    public static void setGlobalLog(LogLevel logLevel) {
        globalLoggingInterceptor = HttpRequest.getLoggingInterceptor(logLevel.getLevel());
    }

    static String handleValue(@Nullable Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    private static void disableSslValidation(OkHttpClient.Builder builder) {
        try {
            X509TrustManager disabledTrustManager = DisableValidationTrustManager.INSTANCE;
            TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, Holder.SECURE_RANDOM);
            SSLSocketFactory disabledSslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(disabledSslSocketFactory, disabledTrustManager);
            builder.hostnameVerifier((HostnameVerifier)TrustAllHostNames.INSTANCE);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }
}

