/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.http;

import com.cssw.kylin.http.AsyncCall;
import com.cssw.kylin.http.Exchange;
import com.cssw.kylin.http.HttpRequest;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class MultipartFormBuilder {
    private final HttpRequest request;
    private final MultipartBody.Builder formBuilder;

    MultipartFormBuilder(HttpRequest request) {
        this.request = request;
        this.formBuilder = new MultipartBody.Builder();
    }

    public MultipartFormBuilder add(String name, @Nullable Object value) {
        this.formBuilder.addFormDataPart(name, HttpRequest.handleValue(value));
        return this;
    }

    public MultipartFormBuilder addMap(@Nullable Map<String, Object> formMap) {
        if (formMap != null && !formMap.isEmpty()) {
            formMap.forEach(this::add);
        }
        return this;
    }

    public MultipartFormBuilder add(String name, File file) {
        String fileName = file.getName();
        return this.add(name, fileName, file);
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, File file) {
        RequestBody fileBody = RequestBody.create(null, (File)file);
        return this.add(name, filename, fileBody);
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, RequestBody fileBody) {
        this.formBuilder.addFormDataPart(name, filename, fileBody);
        return this;
    }

    public MultipartFormBuilder add(RequestBody body) {
        this.formBuilder.addPart(body);
        return this;
    }

    public MultipartFormBuilder add(@Nullable Headers headers, RequestBody body) {
        this.formBuilder.addPart(headers, body);
        return this;
    }

    public MultipartFormBuilder add(MultipartBody.Part part) {
        this.formBuilder.addPart(part);
        return this;
    }

    public HttpRequest build() {
        this.formBuilder.setType(MultipartBody.FORM);
        MultipartBody formBody = this.formBuilder.build();
        this.request.multipartForm(formBody);
        return this.request;
    }

    public Exchange execute() {
        return this.build().execute();
    }

    public AsyncCall async() {
        return this.build().async();
    }
}

