package com.cssw.swagger;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import lombok.Setter;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.beans.factory.FactoryBean;

/**
 * @author Feng Chen
 */
@Setter
public class GlobalOpenApiCustomizerFactoryBean implements FactoryBean<GlobalOpenApiCustomizer> {

    private SwaggerProperties swaggerProperties;

    @Override
    public GlobalOpenApiCustomizer getObject() throws Exception {
        return newCustomizer();
    }

    @Override
    public Class<?> getObjectType() {
        return GlobalOpenApiCustomizer.class;
    }

    private GlobalOpenApiCustomizer newCustomizer() {
        return openApi -> {
            String schema = getSchema();
            if (schema == null) {
                return;
            }
            openApi.getPaths().forEach((name, path) -> {
                path.readOperations().forEach(operation -> {
                    operation.addSecurityItem(new SecurityRequirement().addList(schema));
                });
            });
        };
    }

    private String getSchema() {
        if (swaggerProperties.getAuthorization().isEnabled()) {
            return swaggerProperties.getAuthorization().getName();
        } else if (swaggerProperties.getOauth2().isEnabled()) {
            return swaggerProperties.getOauth2().getName();
        } else {
            return null;
        }
    }
}
