package com.cssw.swagger;

import lombok.Setter;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.FactoryBean;

/**
 * @author Feng Chen
 */
@Setter
public class GroupedOpenApiFactoryBean implements FactoryBean<GroupedOpenApi> {

    private SwaggerProperties.Docket docket;

    @Override
    public GroupedOpenApi getObject() throws Exception {
        return GroupedOpenApi.builder()
                .group(docket.getTitle())
                .displayName(docket.getTitle())
                .packagesToScan(docket.getBasePackage())
                .pathsToMatch("/**")
                .build();
    }

    @Override
    public Class<?> getObjectType() {
        return GroupedOpenApi.class;
    }

}
