package com.cssw.swagger;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.util.Properties;

/**
 * @author Feng Chen
 */
public class SwaggerContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {

    private SwaggerProperties swaggerProperties;

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        Properties props = System.getProperties();
        env(applicationContext.getEnvironment());
        props.setProperty("knife4j.enable", "true");
        props.setProperty("knife4j.setting.enable-search", String.valueOf(swaggerProperties.getEnableSearch()));
        props.setProperty("knife4j.setting.enable-debug", String.valueOf(swaggerProperties.getEnableDebug()));
        props.setProperty("knife4j.setting.enable-footer", "false");
        props.setProperty("knife4j.setting.enable-footer-custom", "true");
        props.setProperty("knife4j.setting.footer-custom-content", swaggerProperties.getCopyright());
        if (swaggerProperties.getEnabled()) {
            props.setProperty("knife4j.production", "false");
        } else {
            props.setProperty("knife4j.production", "true");
        }
        if (swaggerProperties.getBasic().getEnable()) {
            props.setProperty("knife4j.basic.enable", String.valueOf(swaggerProperties.getBasic().getEnable()));
            props.setProperty("knife4j.basic.username", String.valueOf(swaggerProperties.getBasic().getUsername()));
            props.setProperty("knife4j.basic.password", String.valueOf(swaggerProperties.getBasic().getPassword()));
        }
    }

    private void env(Environment environment) {
        swaggerProperties = Binder.get(environment)
                .bind("springboot.swagger", SwaggerProperties.class)
                .orElse(new SwaggerProperties());
    }

}
