package com.cssw.swagger;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Feng Chen
 */
@Data
@ConfigurationProperties(prefix = "springboot.swagger")
public class SwaggerProperties {

    /**
     * 是否开启 swagger，默认：true
     */
    private Boolean enabled = true;
    /**
     * 开启API搜索
     */
    private Boolean enableSearch = true;
    /**
     * 开启API调试
     */
    private Boolean enableDebug = true;
    /**
     * 主题
     */
    private String title;
    /**
     * 描述
     */
    private String description;
    /**
     * 版本
     */
    private String version = "V1.0";
    /**
     * host 信息
     */
    private String host = "";
    /**
     * 许可证
     */
    private String license = "Powered By Cssw";
    /**
     * 许可证URL
     */
    private String licenseUrl = "http://www.csswtech.com";
    /**
     * 服务条款URL
     */
    private String termsOfServiceUrl = "http://www.csswtech.com";
    /**
     * 版权
     */
    private String copyright = "Copyright © 2019-2099 长沙数物信息科技有限公司, All Rights Reserved";
    /**
     * 联系人信息
     */
    private Contact contact = new Contact();
    /**
     * 访问控制
     */
    private Basic basic = new Basic();
    /**
     * 文档
     */
    private List<Docket> dockets = new ArrayList<>();
    /**
     * 全局统一请求头
     */
    private final List<Header> headers = new ArrayList<>();
    /**
     * api key 认证
     **/
    private final Authorization authorization = new Authorization();
    /**
     * oauth2 认证
     */
    private final Oauth2 oauth2 = new Oauth2();

    /**
     * 基础认证
     */
    @Getter
    @Setter
    public static class Basic {

        /**
         * 开启基础认证
         */
        private Boolean enable = false;

        /**
         * 用户名称
         */
        private String username = "cssw";

        /**
         * 用户密码
         */
        private String password = "cssw";

    }

    /**
     * 接口文档
     */
    @Getter
    @Setter
    public static class Docket {
        /**
         * 标题
         */
        private String title = "XXX接口文档";
        /**
         * swagger解析的包路径
         */
        private String basePackage;

    }

    /**
     * 联系人信息
     */
    @Getter
    @Setter
    public static class Contact {

        /**
         * 联系人
         */
        private String name = "cssw";

        /**
         * 联系人URL
         */
        private String url = "";

        /**
         * 联系人email
         */
        private String email = "";

    }

    /**
     * securitySchemes 支持方式之一 ApiKey
     */
    @Getter
    @Setter
    public static class Authorization {
        /**
         * 开启Authorization，默认：false
         */
        private boolean enabled = false;
        /**
         * 鉴权策略ID，对应 SecurityReferences ID，默认：Authorization
         */
        private String name = "Authorization";
        /**
         * 鉴权传递的Header参数，默认：Authorization
         */
        private String keyName = "Authorization";
    }

    /**
     * oauth2 认证
     */
    @Getter
    @Setter
    public static class Oauth2 {
        /**
         * 开启Oauth2，默认：false
         */
        private boolean enabled = false;
        /**
         * oath2 名称，默认：oauth2
         */
        private String name = "oauth2";
        /**
         * authorize url
         */
        private String authorizeUrl;
        /**
         * token url
         */
        private String tokenUrl;
        /**
         * 授权类型
         */
        private GrantTypes grantType = GrantTypes.AUTHORIZATION_CODE;
        /**
         * oauth2 scope 列表
         */
        private List<AuthorizationScope> scopes = new ArrayList<>();
    }

    /**
     * 权限范围
     */
    @Getter
    @Setter
    public static class AuthorizationScope {
        /**
         * 权限
         */
        private String scope;
        /**
         * 描述
         */
        private String description;
    }

    /**
     * 全局通用请求头
     */
    @Getter
    @Setter
    public static class Header {
        /**
         * 请求头名
         */
        private String name;
        /**
         * 请求头描述
         */
        private String description;
        /**
         * 是否必须，默认：false
         */
        private boolean required = false;
    }

    /**
     * oauth2 认证类型
     */
    public enum GrantTypes {
        /**
         * authorization_code
         */
        AUTHORIZATION_CODE,
        /**
         * client_credentials
         */
        CLIENT_CREDENTIALS,
        /**
         * implicit
         */
        IMPLICIT,
        /**
         * Password
         */
        PASSWORD;
    }
}
