package com.cssw.swagger;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author Feng Chen
 */
public class SwaggerRegistrar implements ImportBeanDefinitionRegistrar, EnvironmentAware {

    private SwaggerProperties swaggerProperties;

    private static int groupIndex = 0;

    @Override
    public void setEnvironment(Environment environment) {
        // swagger 配置信息
        swaggerProperties = Binder.get(environment)
                .bind("springboot.swagger", SwaggerProperties.class)
                .orElse(new SwaggerProperties());
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        registerOpenApi(registry);
        registerGroupOpenApi(registry);
        registerOpenApiCustomizer(registry);
    }

    // 注册OpenApi
    private void registerOpenApi(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(OpenApiFactoryBean.class);
        builder.addPropertyValue("swaggerProperties", swaggerProperties);
        registry.registerBeanDefinition("openApi", builder.getBeanDefinition());
    }

    // 注册GroupOpenApi
    private void registerGroupOpenApi(BeanDefinitionRegistry registry) {
        for (SwaggerProperties.Docket docket : swaggerProperties.getDockets()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GroupedOpenApiFactoryBean.class);
            builder.addPropertyValue("docket", docket);
            registry.registerBeanDefinition("groupOpenApi_" + groupIndex++, builder.getBeanDefinition());
        }
    }

    // 注册GlobalOpenApiCustomizer
    private void registerOpenApiCustomizer(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GlobalOpenApiCustomizerFactoryBean.class);
        builder.addPropertyValue("swaggerProperties", swaggerProperties);
        registry.registerBeanDefinition("openApiCustomizer", builder.getBeanDefinition());
    }

}
