/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.dubbo.core.region;

import com.alibaba.fastjson.JSON;
import com.cssw.swshop.busi.dubbo.core.region.RegionsService;
import com.cssw.swshop.busi.model.base.context.Region;
import com.cssw.swshop.busi.model.system.dos.Regions;
import com.cssw.swshop.framework.logs.Logger;
import com.cssw.swshop.framework.logs.LoggerFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.format.Formatter;

public class RegionFormatter
implements Formatter<Region> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RegionsService regionsService;

    public RegionFormatter() {
    }

    public RegionFormatter(RegionsService regionsService) {
        this.regionsService = regionsService;
    }

    public Region parse(String regionId, Locale locale) throws ParseException {
        Regions regions = this.regionsService.getRegion(Long.valueOf(regionId));
        if (regions == null || regions.getRegionGrade() < 2) {
            this.logger.error("regions:" + JSON.toJSONString((Object)regions));
            throw new IllegalArgumentException("\u5730\u533a\u4e0d\u5408\u6cd5\uff0c\u8bf7\u5148\u9009\u62e9\u7701\u5e02\uff01");
        }
        String regionPath = regions.getRegionPath();
        regionPath = regionPath.substring(1, regionPath.length());
        String[] regionPathArray = regionPath.split(",");
        ArrayList<Regions> rList = new ArrayList<Regions>();
        for (String path : regionPathArray) {
            Regions region = this.regionsService.getRegion(Long.valueOf(path));
            if (region == null) {
                this.logger.error("region:" + JSON.toJSONString((Object)regions));
                throw new IllegalArgumentException("\u5730\u533a\u4e0d\u5408\u6cd5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458+[" + path + "]");
            }
            rList.add(region);
        }
        this.logger.error("info >> rList:" + JSON.toJSONString(rList));
        return this.createRegion(rList);
    }

    private Region createRegion(List<Regions> list) {
        Region region = new Region();
        for (Regions regions : list) {
            if (regions.getRegionGrade() == 1) {
                region.setProvinceId(regions.getId());
                region.setProvince(regions.getLocalName());
                continue;
            }
            if (regions.getRegionGrade() == 2) {
                region.setCityId(regions.getId());
                region.setCity(regions.getLocalName());
                continue;
            }
            if (regions.getRegionGrade() == 3) {
                region.setCountyId(regions.getId());
                region.setCounty(regions.getLocalName());
                continue;
            }
            if (regions.getRegionGrade() != 4) continue;
            region.setTownId(regions.getId());
            region.setTown(regions.getLocalName());
        }
        return region;
    }

    public String print(Region object, Locale locale) {
        return object.toString();
    }
}

