/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.base;

import com.cssw.swshop.busi.model.base.DomainSettings;
import com.cssw.swshop.framework.SwShopConfig;
import com.cssw.swshop.framework.context.request.ThreadContextHolder;
import com.cssw.swshop.framework.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DomainHelper {
    private static final String RE_TOP = "[\\w-]+\\.(com.cn|net.cn|gov.cn|org\\.nz|org.cn|com|net|org|gov|cc|biz|info|cn|co)\\b()*";
    private static final String BUYER_API = "api.buyer.";
    @Autowired
    private SwShopConfig swShopConfig;
    @Autowired
    private DomainSettings domainSettings;

    public String getBuyerDomain() {
        String buyerDomain = this.domainSettings.getBuyer();
        if (buyerDomain.indexOf("http") != -1) {
            return buyerDomain;
        }
        return this.swShopConfig.getScheme() + buyerDomain;
    }

    public String getMobileDomain() {
        String mobileDomain = this.domainSettings.getMobileBuyer();
        if (mobileDomain.indexOf("http") != -1) {
            return mobileDomain;
        }
        return this.swShopConfig.getScheme() + mobileDomain;
    }

    public String getTopDomain() {
        String result = DomainHelper.getUrlDomain();
        Pattern pattern = Pattern.compile(RE_TOP, 2);
        try {
            Matcher matcher = pattern.matcher(DomainHelper.getUrlDomain());
            matcher.find();
            result = matcher.group();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getCallback() {
        String callback = this.domainSettings.getCallback();
        String buyer = BUYER_API;
        if (StringUtil.isEmpty((String)callback)) {
            callback = StringUtil.isEmpty((String)DomainHelper.getUrlDomain()) ? buyer + this.getTopDomain() : DomainHelper.getUrlDomain();
        }
        if (callback.indexOf("http") != -1) {
            return callback;
        }
        return this.swShopConfig.getScheme() + callback;
    }

    private static String getUrlDomain() {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        if (request != null) {
            String contextPath;
            String serverName = request.getServerName();
            int port = request.getServerPort();
            String portStr = "";
            if (port != 80) {
                portStr = ":" + port;
            }
            if ("/".equals(contextPath = request.getContextPath())) {
                contextPath = "";
            }
            return serverName + portStr + contextPath;
        }
        return "null";
    }
}

