/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.base;

import com.cssw.swshop.busi.model.statistics.enums.QueryDateType;
import com.cssw.swshop.busi.model.statistics.exception.StatisticsException;
import com.cssw.swshop.framework.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;

@ApiModel
public class SearchCriteria
implements Serializable {
    @ApiModelProperty(name="cycle_type", value="\u5468\u671f YEAR:\u5e74 MONTH:\u6708", required=true, allowableValues="YEAR,MONTH")
    private String cycleType;
    @ApiModelProperty(name="year", value="\u5e74\u4efd", example="2016")
    private Integer year;
    @ApiModelProperty(name="month", value="\u6708\u4efd", example="11")
    private Integer month;
    @ApiModelProperty(name="seller_id", value="\u5e97\u94faid \u7ba1\u7406\u5458\u53ef\u75280\u67e5\u8be2\u5168\u5e73\u53f0", example="0")
    private Long sellerId;
    @ApiModelProperty(name="category_id", value="\u5206\u7c7bid 0\u5168\u90e8", example="0")
    private Long categoryId;

    public static void checkDataParams(String cycleType, Integer year, Integer month) throws StatisticsException {
        if (cycleType == null || year == null) {
            throw new StatisticsException("\u65e5\u671f\u7c7b\u578b\u53ca\u5e74\u4efd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (cycleType.equals(QueryDateType.MONTH.value()) && month == null) {
            throw new StatisticsException("\u6309\u6708\u67e5\u8be2\u65f6\uff0c\u6708\u4efd\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    public static void checkDataParams(SearchCriteria searchCriteria, boolean checkDate, boolean checkCategory, boolean checkSeller) throws StatisticsException {
        if (checkDate) {
            if (searchCriteria.getCycleType() == null || searchCriteria.getYear() == null) {
                throw new StatisticsException("\u65e5\u671f\u7c7b\u578b\u53ca\u5e74\u4efd\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (searchCriteria.getCycleType().equals(QueryDateType.MONTH.value()) && searchCriteria.getMonth() == null) {
                throw new StatisticsException("\u6309\u6708\u67e5\u8be2\u65f6\uff0c\u6708\u4efd\u4e0d\u53ef\u4e3a\u7a7a");
            }
        }
        if (checkCategory && searchCriteria.getCategoryId() == null) {
            throw new StatisticsException("\u5546\u54c1\u5206\u7c7b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (checkSeller && searchCriteria.getSellerId() == null) {
            throw new StatisticsException("\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u5e97\u94fa");
        }
    }

    public SearchCriteria() {
    }

    public static Integer[] defaultPrice() {
        Integer[] prices = new Integer[]{0, 100, 1000, 10000, 100000};
        return prices;
    }

    public SearchCriteria(SearchCriteria searchCriteria) {
        LocalDate localDate;
        if (StringUtil.isEmpty((String)searchCriteria.getCycleType())) {
            searchCriteria.setCycleType(QueryDateType.YEAR.name());
        }
        if (searchCriteria.getYear() == null) {
            localDate = LocalDate.now();
            searchCriteria.setYear(localDate.getYear());
        }
        if (searchCriteria.getMonth() == null) {
            localDate = LocalDate.now();
            searchCriteria.setMonth(localDate.getMonthValue());
        }
        if (searchCriteria.getSellerId() == null) {
            searchCriteria.setSellerId(0L);
        }
        if (searchCriteria.getCategoryId() == null) {
            searchCriteria.setCategoryId(0L);
        }
        this.setCategoryId(searchCriteria.getCategoryId());
        this.setSellerId(searchCriteria.getSellerId());
        this.setYear(searchCriteria.getYear());
        this.setMonth(searchCriteria.getMonth());
        this.setCycleType(searchCriteria.getCycleType());
    }

    public String getCycleType() {
        return this.cycleType;
    }

    public void setCycleType(String cycleType) {
        this.cycleType = cycleType;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Long getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
}

