/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.orderbill.vo;

import com.cssw.swshop.busi.model.goods.enums.Permission;
import com.cssw.swshop.busi.model.orderbill.enums.BillStatusEnum;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class OperateAllowable
implements Serializable {
    private BillStatusEnum status;
    private Permission permission;
    @ApiModelProperty(name="allow_recon", value="\u662f\u5426\u5141\u8bb8\u5bf9\u8d26", required=false)
    private Boolean allowRecon;
    @ApiModelProperty(name="allow_pay", value="\u662f\u5426\u5141\u8bb8\u4ed8\u6b3e", required=false)
    private Boolean allowPay;
    @ApiModelProperty(name="allow_auth", value="\u662f\u5426\u5141\u8bb8\u5ba1\u6838", required=false)
    private Boolean allowAuth;
    @ApiModelProperty(name="allow_complete", value="\u662f\u5426\u5141\u8bb8\u5b8c\u6210", required=false)
    private Boolean allowComplete;
    @ApiModelProperty(name="allow_next_step", value="\u662f\u5426\u5141\u8bb8\u4e0b\u4e00\u6b65\u64cd\u4f5c", hidden=true)
    private Boolean allowNextStep;

    public OperateAllowable(BillStatusEnum status, Permission permission) {
        this.status = status;
        this.permission = permission;
    }

    public OperateAllowable() {
    }

    public Boolean getAllowNextStep() {
        switch (this.status) {
            case OUT: {
                this.allowNextStep = this.getAllowRecon();
                break;
            }
            case RECON: {
                this.allowNextStep = this.getAllowAuth();
                break;
            }
            case PASS: {
                this.allowNextStep = this.getAllowPay();
                break;
            }
            case PAY: {
                this.allowNextStep = this.getAllowComplete();
                break;
            }
        }
        return this.allowNextStep;
    }

    public Boolean getAllowRecon() {
        return BillStatusEnum.OUT.equals((Object)this.status) && Permission.SELLER.equals((Object)this.permission);
    }

    public Boolean getAllowAuth() {
        return BillStatusEnum.RECON.equals((Object)this.status) && Permission.ADMIN.equals((Object)this.permission);
    }

    public Boolean getAllowPay() {
        return BillStatusEnum.PASS.equals((Object)this.status) && Permission.ADMIN.equals((Object)this.permission);
    }

    public Boolean getAllowComplete() {
        return BillStatusEnum.PAY.equals((Object)this.status) && (Permission.SELLER.equals((Object)this.permission) || Permission.CLIENT.equals((Object)this.permission));
    }
}

