/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.promotion.seckill.vo;

import com.cssw.swshop.busi.model.promotion.seckill.dto.SeckillGoodsDTO;
import com.cssw.swshop.framework.logs.Logger;
import com.cssw.swshop.framework.logs.LoggerFactory;
import com.cssw.swshop.framework.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SeckillGoodsVO
extends SeckillGoodsDTO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @ApiModelProperty(value="\u79d2\u6740\u5f00\u59cb\u65f6\u523b\uff0c\u6ce8\u610f\u4e0d\u662f\u65f6\u95f4\uff0c\u662f\u949f\u70b9\uff0c\u6bd4\u598210")
    private Integer seckillStartTime;
    @ApiModelProperty(value="\u79d2\u6740\u5f00\u59cb\u65f6\u95f4\uff0c\u8fd9\u4e2a\u662f\u65f6\u95f4\u6233")
    private Long startTime;
    @ApiModelProperty(value="\u8ddd\u79bb\u6d3b\u52a8\u7ed3\u675f\u7684\u65f6\u95f4\uff0c\u79d2\u4e3a\u5355\u4f4d")
    private Long distanceEndTime;
    @ApiModelProperty(value="\u6d3b\u52a8\u662f\u5426\u5df2\u7ecf\u5f00\u59cb\u30011:\u6d3b\u52a8\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c0:\u672a\u5f00\u59cb")
    private Integer isStart;
    @ApiModelProperty(value="\u5269\u4f59\u53ef\u552e\u6570\u91cf")
    private Integer remainQuantity;
    @ApiModelProperty(value="\u8ddd\u79bb\u6d3b\u52a8\u5f00\u59cb\u7684\u65f6\u95f4\uff0c\u79d2\u4e3a\u5355\u4f4d\u3002\u5982\u679c\u6d3b\u52a8\u7684\u5f00\u59cb\u65f6\u95f4\u662f10\u70b9\uff0c\u670d\u52a1\u5668\u65f6\u95f4\u4e3a8\u70b9\uff0c\u8ddd\u79bb\u5f00\u59cb\u8fd8\u6709\u591a\u5c11\u65f6\u95f4")
    private Long distanceStartTime;
    @ApiModelProperty(value="\u5546\u5bb6ID")
    private Long sellerId;
    @ApiModelProperty(value="\u79d2\u6740\u6d3b\u52a8ID")
    private Long seckillId;

    public SeckillGoodsVO() {
    }

    public SeckillGoodsVO(SeckillGoodsVO goods) {
        this.setGoodsId(goods.getGoodsId());
        this.setSeckillPrice(goods.getSeckillPrice());
        this.setSoldQuantity(goods.getSoldQuantity());
        this.setOriginalPrice(goods.getOriginalPrice());
        this.setSoldNum(goods.getSoldNum());
        this.setStartTime(goods.getStartTime());
        this.setSeckillId(goods.getSeckillId());
    }

    public SeckillGoodsVO(SeckillGoodsVO seckillGoods, Integer key) {
        this.setGoodsId(seckillGoods.getGoodsId());
        this.setSeckillPrice(seckillGoods.getSeckillPrice());
        this.setSoldQuantity(seckillGoods.getSoldQuantity());
        this.setOriginalPrice(seckillGoods.getOriginalPrice());
        this.setSoldNum(seckillGoods.getSoldNum());
        this.setSeckillId(seckillGoods.getSeckillId());
        this.setSeckillStartTime(key);
        this.setStartTime(seckillGoods.getStartTime());
        this.setRemainQuantity(seckillGoods.getSoldQuantity() - seckillGoods.getSoldNum());
        this.countSeckillTime(this);
    }

    private void countSeckillTime(SeckillGoodsVO goodsVO) {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int timeLine = goodsVO.getSeckillStartTime();
        long distanceEndTime = 0L;
        long distanceStartTime = 0L;
        int isStart = 0;
        if (hour >= timeLine) {
            long endTime = DateUtil.endOfTodDay();
            long currentTime = DateUtil.getDateline();
            distanceEndTime = endTime - currentTime;
            isStart = 1;
        } else {
            long currentTime = DateUtil.getDateline();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            long startTime = DateUtil.getDateline((String)(df.format(new Date()) + " " + timeLine + ":00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            distanceStartTime = currentTime - startTime;
        }
        goodsVO.setSeckillStartTime(timeLine);
        goodsVO.setDistanceEndTime(distanceEndTime);
        goodsVO.setDistanceStartTime(distanceStartTime);
        goodsVO.setIsStart(isStart);
    }

    public Long getSeckillId() {
        return this.seckillId;
    }

    public void setSeckillId(Long seckillId) {
        this.seckillId = seckillId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.logger.info("\u9650\u65f6\u62a2\u8d2d\u5f00\u59cb\u65f6\u95f4\u88ab\u7f6e\u4e3a\uff1a" + startTime);
        this.logger.info("\u5bf9\u8c61\u4e3a\uff1a" + this.toString());
        this.startTime = startTime;
    }

    public Integer getSeckillStartTime() {
        return this.seckillStartTime;
    }

    public void setSeckillStartTime(Integer seckillStartTime) {
        this.seckillStartTime = seckillStartTime;
    }

    public Long getDistanceEndTime() {
        return this.distanceEndTime;
    }

    public void setDistanceEndTime(Long distanceEndTime) {
        this.distanceEndTime = distanceEndTime;
    }

    public Integer getIsStart() {
        return this.isStart;
    }

    public void setIsStart(Integer isStart) {
        this.isStart = isStart;
    }

    public Integer getRemainQuantity() {
        if (this.remainQuantity < 0 || this.remainQuantity == null) {
            return 0;
        }
        return this.remainQuantity;
    }

    public void setRemainQuantity(Integer remainQuantity) {
        this.remainQuantity = remainQuantity;
    }

    public Long getDistanceStartTime() {
        return this.distanceStartTime;
    }

    public void setDistanceStartTime(Long distanceStartTime) {
        this.distanceStartTime = distanceStartTime;
    }

    public Long getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
}

