/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.promotion.tool.enums;

import java.util.ArrayList;
import java.util.List;

public enum PromotionTypeEnum {
    NO("no", "\u4e0d\u53c2\u4e0e\u6d3b\u52a8"),
    MINUS("minusPlugin", "\u5355\u54c1\u7acb\u51cf"),
    HALF_PRICE("halfPricePlugin", "\u7b2c\u4e8c\u4ef6\u534a\u4ef7"),
    FULL_DISCOUNT("fullDiscountPlugin", "\u6ee1\u4f18\u60e0"),
    SECKILL("seckillPlugin", "\u9650\u65f6\u62a2\u8d2d"),
    COUPON("no", "\u4f18\u60e0\u5238");

    private String pluginId;
    private String promotionName;

    private PromotionTypeEnum(String pluginId, String promotionName) {
        this.pluginId = pluginId;
        this.promotionName = promotionName;
    }

    public String getPromotionName() {
        return this.promotionName;
    }

    public void setPromotionName(String promotionName) {
        this.promotionName = promotionName;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public static List<String> getSingle() {
        ArrayList<String> pluginId = new ArrayList<String>();
        pluginId.add(HALF_PRICE.getPluginId());
        pluginId.add(MINUS.getPluginId());
        pluginId.add(SECKILL.getPluginId());
        return pluginId;
    }

    public static List<String> getGroup() {
        ArrayList<String> pluginId = new ArrayList<String>();
        pluginId.add(FULL_DISCOUNT.getPluginId());
        return pluginId;
    }

    public static List<String> getIndependent() {
        ArrayList<String> pluginId = new ArrayList<String>();
        pluginId.add(SECKILL.getPluginId());
        return pluginId;
    }

    public static boolean isSingle(String type) {
        if (HALF_PRICE.name().equals(type)) {
            return true;
        }
        return MINUS.name().equals(type);
    }

    public boolean isGroup(String type) {
        return FULL_DISCOUNT.name().equals(type);
    }

    public static String getPlugin(String type) {
        if (FULL_DISCOUNT.name().equals(type)) {
            return PromotionTypeEnum.FULL_DISCOUNT.pluginId;
        }
        if (HALF_PRICE.name().equals(type)) {
            return PromotionTypeEnum.HALF_PRICE.pluginId;
        }
        if (MINUS.name().equals(type)) {
            return PromotionTypeEnum.MINUS.pluginId;
        }
        return "";
    }

    public static PromotionTypeEnum myValueOf(String promotionName) {
        try {
            return PromotionTypeEnum.valueOf(promotionName);
        }
        catch (Exception e) {
            System.out.println("\u53d1\u73b0\u672a\u77e5\u7684\u6d3b\u52a8\u7c7b\u578b\uff1a" + promotionName);
            return null;
        }
    }
}

