/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.swshop.busi.model.system.vo;

import com.cssw.swshop.busi.model.system.vo.ProgressEnum;
import java.io.Serializable;
import java.math.BigDecimal;

public class TaskProgress
implements Serializable {
    public static final String PROCESS = "{PROCESS}_";
    private String id;
    private double sumPer;
    private double stepPer;
    private String text;
    private String taskStatus;
    private int taskTotal;
    private String message;

    public TaskProgress() {
    }

    public TaskProgress(int total) {
        this.taskTotal = total;
        this.taskStatus = ProgressEnum.DOING.name();
        BigDecimal b1 = new BigDecimal("100");
        BigDecimal b2 = new BigDecimal("" + this.taskTotal);
        this.stepPer = b1.divide(b2, 5, 4).doubleValue();
    }

    public void step(String text) {
        this.sumPer += this.stepPer;
        this.text = text;
    }

    public void success() {
        this.sumPer = 100.0;
        this.text = "\u5b8c\u6210";
        this.taskStatus = ProgressEnum.SUCCESS.name();
    }

    public void fail(String text, String message) {
        this.taskStatus = ProgressEnum.EXCEPTION.name();
        this.message = message;
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static String getPROCESS() {
        return PROCESS;
    }

    public String getId() {
        return this.id;
    }

    public double getSumPer() {
        return this.sumPer;
    }

    public void setSumPer(double sumPer) {
        this.sumPer = sumPer;
    }

    public double getStepPer() {
        return this.stepPer;
    }

    public void setStepPer(double stepPer) {
        this.stepPer = stepPer;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public int getTaskTotal() {
        return this.taskTotal;
    }

    public void setTaskTotal(int taskTotal) {
        this.taskTotal = taskTotal;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

