/*
 * Decompiled with CFR 0.152.
 */
package com.feiniaojin.gracefulresponse.advice;

import com.feiniaojin.gracefulresponse.GracefulResponseProperties;
import com.feiniaojin.gracefulresponse.advice.AbstractResponseBodyAdvice;
import com.feiniaojin.gracefulresponse.advice.AdviceSupport;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.ResponseBodyAdvicePredicate;
import com.feiniaojin.gracefulresponse.advice.lifecycle.response.ResponseBodyAdviceProcessor;
import com.feiniaojin.gracefulresponse.api.ResponseFactory;
import com.feiniaojin.gracefulresponse.data.Response;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Order(value=1000)
@ControllerAdvice
public class GrNotVoidResponseBodyAdvice
extends AbstractResponseBodyAdvice
implements ResponseBodyAdvicePredicate,
ResponseBodyAdviceProcessor {
    private final Logger logger = LoggerFactory.getLogger(GrNotVoidResponseBodyAdvice.class);
    @Resource
    private ResponseFactory responseFactory;
    @Resource
    private GracefulResponseProperties properties;
    @Resource
    private AdviceSupport adviceSupport;
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    @Override
    public Object process(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return this.responseFactory.newSuccessInstance();
        }
        if (body instanceof Response) {
            return body;
        }
        if (this.logger.isDebugEnabled()) {
            String path = request.getURI().getPath();
            this.logger.debug("Graceful Response:\u975e\u7a7a\u8fd4\u56de\u503c\uff0c\u6267\u884c\u5c01\u88c5:path={}", (Object)path);
        }
        return this.responseFactory.newSuccessInstance(body);
    }

    @Override
    public boolean shouldApplyTo(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> clazz) {
        RequestAttributes requestAttributes;
        Set<Class<?>> excludeReturnTypes;
        Method method = methodParameter.getMethod();
        if (Objects.isNull(method) || method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Response.class) || !this.adviceSupport.isJsonHttpMessageConverter(clazz)) {
            this.logger.debug("Graceful Response:method\u4e3a\u7a7a\u3001\u8fd4\u56de\u503c\u4e3avoid\u548cResponse\u7c7b\u578b\u3001\u975eJSON\uff0c\u8df3\u8fc7");
            return false;
        }
        if (this.adviceSupport.matchExcludeFromGracefulResponse(method)) {
            return false;
        }
        List<String> excludePackages = this.properties.getExcludePackages();
        if (!CollectionUtils.isEmpty(excludePackages)) {
            String packageName = method.getDeclaringClass().getPackage().getName();
            if (excludePackages.stream().anyMatch(item -> ANT_PATH_MATCHER.match(item, packageName))) {
                this.logger.debug("Graceful Response:\u5339\u914d\u5230excludePackages\u4f8b\u5916\u914d\u7f6e\uff0c\u8df3\u8fc7:packageName={},", (Object)packageName);
                return false;
            }
        }
        if (!CollectionUtils.isEmpty(excludeReturnTypes = this.properties.getExcludeReturnTypes()) && excludeReturnTypes.contains(method.getReturnType())) {
            this.logger.debug("Graceful Response:\u5339\u914d\u5230excludeReturnTypes\u4f8b\u5916\u914d\u7f6e\uff0c\u8df3\u8fc7:returnType={},", method.getReturnType());
            return false;
        }
        List<String> excludeUrls = this.properties.getExcludeUrls();
        if (!CollectionUtils.isEmpty(excludeUrls)) {
            requestAttributes = RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            String requestUri = request.getRequestURI();
            for (String excludeUrl : excludeUrls) {
                if (!ANT_PATH_MATCHER.match(excludeUrl, requestUri)) continue;
                this.logger.debug("Graceful Response:\u5339\u914d\u5230excludeUrls\u4f8b\u5916\u914d\u7f6e\uff0c\u8df3\u8fc7:excludeUrl={},requestURI={}", (Object)excludeUrl, (Object)requestUri);
                return false;
            }
        }
        if (Objects.isNull(requestAttributes = RequestContextHolder.getRequestAttributes())) {
            return false;
        }
        Exception releaseException = (Exception)requestAttributes.getAttribute("RELEASE_EXCEPTION_KEY", 0);
        if (Objects.nonNull(releaseException) && this.adviceSupport.isMatchExcludeException(releaseException)) {
            return false;
        }
        this.logger.debug("Graceful Response:\u975e\u7a7a\u8fd4\u56de\u503c\uff0c\u9700\u8981\u8fdb\u884c\u5c01\u88c5");
        return true;
    }

    @PostConstruct
    public void init() {
        CopyOnWriteArrayList<ResponseBodyAdvicePredicate> copyOnWriteArrayList = new CopyOnWriteArrayList<ResponseBodyAdvicePredicate>();
        copyOnWriteArrayList.add(this);
        this.setPredicates(copyOnWriteArrayList);
        this.setResponseBodyAdviceProcessor(this);
    }
}

