/*
 * Decompiled with CFR 0.152.
 */
package com.paginate.abslistview;

import android.widget.AbsListView;

class EndScrollListener
implements AbsListView.OnScrollListener {
    private final Callback callback;
    private int visibleThreshold = 5;
    private AbsListView.OnScrollListener delegate;

    public EndScrollListener(Callback callback) {
        this.callback = callback;
    }

    public void onScroll(AbsListView view, int firstVisibleItemPosition, int visibleItemCount, int totalItemCount) {
        if (totalItemCount - visibleItemCount <= firstVisibleItemPosition + this.visibleThreshold) {
            this.callback.onEndReached();
        }
        if (this.delegate != null) {
            this.delegate.onScroll(view, firstVisibleItemPosition, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.delegate != null) {
            this.delegate.onScrollStateChanged(view, scrollState);
        }
    }

    public void setThreshold(int threshold) {
        this.visibleThreshold = Math.max(0, threshold);
    }

    public void setDelegate(AbsListView.OnScrollListener delegate) {
        this.delegate = delegate;
    }

    public AbsListView.OnScrollListener getDelegateScrollListener() {
        return this.delegate;
    }

    public static interface Callback {
        public void onEndReached();
    }
}

