/*
 * Decompiled with CFR 0.152.
 */
package com.paginate.recycler;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.paginate.recycler.LoadingListItemCreator;

class WrapperAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int ITEM_VIEW_TYPE_LOADING = 2147483597;
    private final RecyclerView.Adapter wrappedAdapter;
    private final LoadingListItemCreator loadingListItemCreator;
    private boolean displayLoadingRow = true;

    public WrapperAdapter(RecyclerView.Adapter adapter, LoadingListItemCreator creator) {
        this.wrappedAdapter = adapter;
        this.loadingListItemCreator = creator;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2147483597) {
            return this.loadingListItemCreator.onCreateViewHolder(parent, viewType);
        }
        return this.wrappedAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isLoadingRow(position)) {
            this.loadingListItemCreator.onBindViewHolder(holder, position);
        } else {
            this.wrappedAdapter.onBindViewHolder(holder, position);
        }
    }

    public int getItemCount() {
        return this.displayLoadingRow ? this.wrappedAdapter.getItemCount() + 1 : this.wrappedAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        return this.isLoadingRow(position) ? 2147483597 : this.wrappedAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        return this.isLoadingRow(position) ? -1L : this.wrappedAdapter.getItemId(position);
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
        this.wrappedAdapter.setHasStableIds(hasStableIds);
    }

    public RecyclerView.Adapter getWrappedAdapter() {
        return this.wrappedAdapter;
    }

    boolean isDisplayLoadingRow() {
        return this.displayLoadingRow;
    }

    void displayLoadingRow(boolean displayLoadingRow) {
        if (this.displayLoadingRow != displayLoadingRow) {
            this.displayLoadingRow = displayLoadingRow;
            this.notifyDataSetChanged();
        }
    }

    boolean isLoadingRow(int position) {
        return this.displayLoadingRow && position == this.getLoadingRowPosition();
    }

    private int getLoadingRowPosition() {
        return this.displayLoadingRow ? this.getItemCount() - 1 : -1;
    }
}

