/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;

public class TarImage {
    private final Path path;
    @Nullable
    private ImageReference imageReference;

    public static TarImage at(Path path) {
        return new TarImage(path);
    }

    private TarImage(Path path) {
        this.path = path;
    }

    public TarImage named(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public TarImage named(String imageReference) throws InvalidImageReferenceException {
        return this.named(ImageReference.parse(imageReference));
    }

    Path getPath() {
        return this.path;
    }

    Optional<ImageReference> getImageReference() {
        return Optional.ofNullable(this.imageReference);
    }
}

