/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.DbTemplate;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.ICallback;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.PageSqlKit;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import com.jfinal.plugin.activerecord.cache.ICache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class DbPro {
    protected final Config config;

    public DbPro() {
        if (DbKit.config == null) {
            throw new RuntimeException("The main config is null, initialize ActiveRecordPlugin first");
        }
        this.config = DbKit.config;
    }

    public DbPro(String configName) {
        this.config = DbKit.getConfig(configName);
        if (this.config == null) {
            throw new IllegalArgumentException("Config not found by configName: " + configName);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    protected <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            config.dialect.fillStatement(pst, paras);
            ResultSet rs = pst.executeQuery();
            int colAmount = rs.getMetaData().getColumnCount();
            if (colAmount > 1) {
                while (rs.next()) {
                    Object[] temp = new Object[colAmount];
                    for (int i = 0; i < colAmount; ++i) {
                        temp[i] = rs.getObject(i + 1);
                    }
                    result.add(temp);
                }
            } else if (colAmount == 1) {
                while (rs.next()) {
                    result.add(rs.getObject(1));
                }
            }
            DbKit.close(rs);
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }

    public <T> List<T> query(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<T> list = this.query(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public <T> List<T> query(String sql) {
        return this.query(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> T queryFirst(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryFirst(String sql) {
        List<T> result = this.query(sql, DbKit.NULL_PARA_ARRAY);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryColumn(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        if (result.size() > 0) {
            T temp = result.get(0);
            if (temp instanceof Object[]) {
                throw new ActiveRecordException("Only ONE COLUMN can be queried.");
            }
            return temp;
        }
        return null;
    }

    public <T> T queryColumn(String sql) {
        return this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public String queryStr(String sql, Object ... paras) {
        Object s = this.queryColumn(sql, paras);
        return s != null ? s.toString() : null;
    }

    public String queryStr(String sql) {
        return this.queryStr(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Integer queryInt(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Integer queryInt(String sql) {
        return this.queryInt(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Long queryLong(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Long queryLong(String sql) {
        return this.queryLong(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Double queryDouble(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Double queryDouble(String sql) {
        return this.queryDouble(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Float queryFloat(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Float queryFloat(String sql) {
        return this.queryFloat(sql, DbKit.NULL_PARA_ARRAY);
    }

    public BigDecimal queryBigDecimal(String sql, Object ... paras) {
        Object n = this.queryColumn(sql, paras);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public BigDecimal queryBigDecimal(String sql) {
        return this.queryBigDecimal(sql, DbKit.NULL_PARA_ARRAY);
    }

    public byte[] queryBytes(String sql, Object ... paras) {
        return (byte[])this.queryColumn(sql, paras);
    }

    public byte[] queryBytes(String sql) {
        return (byte[])this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public java.util.Date queryDate(String sql, Object ... paras) {
        return (java.util.Date)this.queryColumn(sql, paras);
    }

    public java.util.Date queryDate(String sql) {
        return (java.util.Date)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Time queryTime(String sql, Object ... paras) {
        return (Time)this.queryColumn(sql, paras);
    }

    public Time queryTime(String sql) {
        return (Time)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Timestamp queryTimestamp(String sql, Object ... paras) {
        return (Timestamp)this.queryColumn(sql, paras);
    }

    public Timestamp queryTimestamp(String sql) {
        return (Timestamp)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Boolean queryBoolean(String sql, Object ... paras) {
        return (Boolean)this.queryColumn(sql, paras);
    }

    public Boolean queryBoolean(String sql) {
        return (Boolean)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Short queryShort(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Short.valueOf(n.shortValue()) : null;
    }

    public Short queryShort(String sql) {
        return this.queryShort(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Byte queryByte(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Byte.valueOf(n.byteValue()) : null;
    }

    public Byte queryByte(String sql) {
        return this.queryByte(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Number queryNumber(String sql, Object ... paras) {
        return (Number)this.queryColumn(sql, paras);
    }

    public Number queryNumber(String sql) {
        return (Number)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    protected int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            int result;
            config.dialect.fillStatement(pst, paras);
            int n = result = pst.executeUpdate();
            return n;
        }
    }

    public int update(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            int n = this.update(this.config, conn, sql, paras);
            return n;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public int update(String sql) {
        return this.update(sql, DbKit.NULL_PARA_ARRAY);
    }

    protected List<Record> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            config.dialect.fillStatement(pst, paras);
            ResultSet rs = pst.executeQuery();
            List<Record> result = config.dialect.buildRecordList(config, rs);
            DbKit.close(rs);
            List<Record> list = result;
            return list;
        }
    }

    public List<Record> find(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Record> list = this.find(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public List<Record> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public List<Record> findAll(String tableName) {
        String sql = this.config.dialect.forFindAll(tableName);
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findFirst(String sql, Object ... paras) {
        List<Record> result = this.find(sql, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Record findFirst(String sql) {
        return this.findFirst(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findById(String tableName, Object idValue) {
        return this.findByIds(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public Record findById(String tableName, String primaryKey, Object idValue) {
        return this.findByIds(tableName, primaryKey, idValue);
    }

    public Record findByIds(String tableName, String primaryKey, Object ... idValues) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValues.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbFindById(tableName, pKeys);
        List<Record> result = this.find(sql, idValues);
        return result.size() > 0 ? result.get(0) : null;
    }

    public boolean deleteById(String tableName, Object idValue) {
        return this.deleteByIds(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public boolean deleteById(String tableName, String primaryKey, Object idValue) {
        return this.deleteByIds(tableName, primaryKey, idValue);
    }

    public boolean deleteByIds(String tableName, String primaryKey, Object ... idValues) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValues.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbDeleteById(tableName, pKeys);
        return this.update(sql, idValues) >= 1;
    }

    public boolean delete(String tableName, String primaryKey, Record record) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length <= 1) {
            Object t = record.get(primaryKey);
            return this.deleteByIds(tableName, primaryKey, t);
        }
        this.config.dialect.trimPrimaryKeys(pKeys);
        Object[] idValue = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            idValue[i] = record.get(pKeys[i]);
            if (idValue[i] != null) continue;
            throw new IllegalArgumentException("The value of primary key \"" + pKeys[i] + "\" can not be null in record object");
        }
        return this.deleteByIds(tableName, primaryKey, idValue);
    }

    public boolean delete(String tableName, Record record) {
        String defaultPrimaryKey = this.config.dialect.getDefaultPrimaryKey();
        Object t = record.get(defaultPrimaryKey);
        return this.deleteByIds(tableName, defaultPrimaryKey, t);
    }

    public int delete(String sql, Object ... paras) {
        return this.update(sql, paras);
    }

    public int delete(String sql) {
        return this.update(sql);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    protected Page<Record> doPaginate(int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            String totalRowSql = "select count(*) " + this.config.dialect.replaceOrderBy(sqlExceptSelect);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<Record> page = this.doPaginateByFullSql(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    protected Page<Record> doPaginateByFullSql(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws SQLException {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must more than 0");
        }
        if (config.dialect.isTakeOverDbPaginate()) {
            return config.dialect.takeOverDbPaginate(conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        List result = this.query(config, conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page<Record>(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page<Record>(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        String sql = config.dialect.forPaginate(pageNumber, pageSize, findSql);
        List<Record> list = this.find(config, conn, sql, paras);
        return new Page<Record>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    protected Page<Record> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws SQLException {
        String totalRowSql = "select count(*) " + config.dialect.replaceOrderBy(sqlExceptSelect);
        StringBuilder findSql = new StringBuilder();
        findSql.append(select).append(' ').append(sqlExceptSelect);
        return this.doPaginateByFullSql(config, conn, pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    protected Page<Record> doPaginateByFullSql(int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            StringBuilder findSqlBuf = new StringBuilder().append(findSql);
            Page<Record> page = this.doPaginateByFullSql(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSqlBuf, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Record> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public Page<Record> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    protected boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        String[] pKeys = primaryKey.split(",");
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.forDbSave(tableName, pKeys, record, sql, paras);
        try (PreparedStatement pst = config.dialect.isOracle() ? conn.prepareStatement(sql.toString(), pKeys) : conn.prepareStatement(sql.toString(), 1);){
            config.dialect.fillStatement(pst, paras);
            int result = pst.executeUpdate();
            config.dialect.getRecordGeneratedKey(pst, record, pKeys);
            boolean bl = result >= 1;
            return bl;
        }
    }

    public boolean save(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean save(String tableName, Record record) {
        return this.save(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    protected boolean update(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        String[] pKeys = primaryKey.split(",");
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = record.get(pKeys[i].trim());
            if (ids[i] != null) continue;
            throw new ActiveRecordException("You can't update record without Primary Key, " + pKeys[i] + " can not be null.");
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forDbUpdate(tableName, pKeys, ids, record, sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        return this.update(config, conn, sql.toString(), paras.toArray()) >= 1;
    }

    public boolean update(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.update(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean update(String tableName, Record record) {
        return this.update(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    public Object execute(ICallback callback) {
        return this.execute(this.config, callback);
    }

    protected Object execute(Config config, ICallback callback) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            Object object = callback.call(conn);
            return object;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tx(Config config, int transactionLevel, IAtom atom) {
        Connection conn = config.getThreadLocalConnection();
        if (conn != null) {
            try {
                boolean result;
                if (conn.getTransactionIsolation() < transactionLevel) {
                    conn.setTransactionIsolation(transactionLevel);
                }
                if (!(result = atom.run())) throw new NestedTransactionHelpException("Notice the outer transaction that the nested transaction return false");
                return true;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(transactionLevel);
            conn.setAutoCommit(false);
            boolean result = atom.run();
            if (result) {
                conn.commit();
            } else {
                conn.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (NestedTransactionHelpException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    LogKit.error(e1.getMessage(), e1);
                }
            }
            LogKit.logNothing(e);
            boolean e1 = false;
            return e1;
        }
        catch (Throwable t) {
            RuntimeException runtimeException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    LogKit.error(e1.getMessage(), e1);
                }
            }
            if (t instanceof RuntimeException) {
                runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            runtimeException = new ActiveRecordException(t);
            throw runtimeException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                LogKit.error(t.getMessage(), t);
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }

    public boolean tx(IAtom atom) {
        return this.tx(this.config, this.config.getTransactionLevel(), atom);
    }

    public boolean tx(int transactionLevel, IAtom atom) {
        return this.tx(this.config, transactionLevel, atom);
    }

    public Future<Boolean> txInNewThread(IAtom atom) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> this.tx(this.config, this.config.getTransactionLevel(), atom));
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    public Future<Boolean> txInNewThread(int transactionLevel, IAtom atom) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> this.tx(this.config, transactionLevel, atom));
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    public List<Record> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.config.getCache();
        List<Record> result = (List<Record>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<Record> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.config.getCache();
        Record result = (Record)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Record findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    protected Page<Record> doPaginateByCache(String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        ICache cache = this.config.getCache();
        Page<Record> result = (Page<Record>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    protected int[] batch(Config config, Connection conn, String sql, Object[][] paras, int batchSize) throws SQLException {
        if (paras == null || paras.length == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int[] result = new int[paras.length];
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            for (int i = 0; i < paras.length; ++i) {
                for (int j = 0; j < paras[i].length; ++j) {
                    Object value = paras[i][j];
                    if (value instanceof java.util.Date) {
                        if (value instanceof Date) {
                            pst.setDate(j + 1, (Date)value);
                            continue;
                        }
                        if (value instanceof Timestamp) {
                            pst.setTimestamp(j + 1, (Timestamp)value);
                            continue;
                        }
                        java.util.Date d = (java.util.Date)value;
                        pst.setTimestamp(j + 1, new Timestamp(d.getTime()));
                        continue;
                    }
                    pst.setObject(j + 1, value);
                }
                pst.addBatch();
                if (++counter < batchSize) continue;
                counter = 0;
                int[] r = pst.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            if (counter != 0) {
                int[] r = pst.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public int[] batch(String sql, Object[][] paras, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, paras, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    protected int[] batch(Config config, Connection conn, String sql, String columns, List list, int batchSize) throws SQLException {
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        Object element = list.get(0);
        if (!(element instanceof Record) && !(element instanceof Model)) {
            throw new IllegalArgumentException("The element in list must be Model or Record.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isModel = element instanceof Model;
        String[] columnArray = columns.split(",");
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = columnArray[i].trim();
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = list.size();
        int[] result = new int[size];
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            for (int i = 0; i < size; ++i) {
                Map<String, Object> map = isModel ? ((Model)list.get(i))._getAttrs() : ((Record)list.get(i)).getColumns();
                for (int j = 0; j < columnArray.length; ++j) {
                    Object value = map.get(columnArray[j]);
                    if (value instanceof java.util.Date) {
                        if (value instanceof Date) {
                            pst.setDate(j + 1, (Date)value);
                            continue;
                        }
                        if (value instanceof Timestamp) {
                            pst.setTimestamp(j + 1, (Timestamp)value);
                            continue;
                        }
                        java.util.Date d = (java.util.Date)value;
                        pst.setTimestamp(j + 1, new Timestamp(d.getTime()));
                        continue;
                    }
                    pst.setObject(j + 1, value);
                }
                pst.addBatch();
                if (++counter < batchSize) continue;
                counter = 0;
                int[] r = pst.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            if (counter != 0) {
                int[] r = pst.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, columns, modelOrRecordList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    protected int[] batch(Config config, Connection conn, List<String> sqlList, int batchSize) throws SQLException {
        if (sqlList == null || sqlList.size() == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = sqlList.size();
        int[] result = new int[size];
        try (Statement st = conn.createStatement();){
            for (int i = 0; i < size; ++i) {
                st.addBatch(sqlList.get(i));
                if (++counter < batchSize) continue;
                counter = 0;
                int[] r = st.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            if (counter != 0) {
                int[] r = st.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public int[] batch(List<String> sqlList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sqlList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    public int[] batchSave(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        Map<String, Object> attrs = model._getAttrs();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forModelSave(TableMapping.me().getTable(model.getClass()), attrs, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), modelList, batchSize);
    }

    public int[] batchSave(String tableName, List<? extends Record> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        Record record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        String[] pKeysNoUse = new String[]{};
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbSave(tableName, pKeysNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), recordList, batchSize);
    }

    public int[] batchUpdate(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        Table table = TableMapping.me().getTable(model.getClass());
        String[] pKeys = table.getPrimaryKey();
        Map<String, Object> attrs = model._getAttrs();
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String attr = e.getKey();
            if (this.config.dialect.isPrimaryKey(attr, pKeys) || !table.hasColumnLabel(attr)) continue;
            attrNames.add(attr);
        }
        for (String pKey : pKeys) {
            attrNames.add(pKey);
        }
        String columns = StrKit.join(attrNames.toArray(new String[attrNames.size()]), ",");
        Set<String> modifyFlag = attrs.keySet();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forModelUpdate(TableMapping.me().getTable(model.getClass()), attrs, modifyFlag, sql, parasNoUse);
        return this.batch(sql.toString(), columns, modelList, batchSize);
    }

    public int[] batchUpdate(String tableName, String primaryKey, List<? extends Record> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        String[] pKeys = primaryKey.split(",");
        this.config.dialect.trimPrimaryKeys(pKeys);
        Record record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        ArrayList<String> colNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            String col = e.getKey();
            if (this.config.dialect.isPrimaryKey(col, pKeys)) continue;
            colNames.add(col);
        }
        for (String pKey : pKeys) {
            colNames.add(pKey);
        }
        String columns = StrKit.join(colNames.toArray(new String[colNames.size()]), ",");
        Object[] idsNoUse = new Object[pKeys.length];
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbUpdate(tableName, pKeys, idsNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns, recordList, batchSize);
    }

    public int[] batchUpdate(String tableName, List<? extends Record> recordList, int batchSize) {
        return this.batchUpdate(tableName, this.config.dialect.getDefaultPrimaryKey(), recordList, batchSize);
    }

    public String getSql(String key) {
        return this.config.getSqlKit().getSql(key);
    }

    public SqlPara getSqlPara(String key, Record record) {
        return this.getSqlPara(key, record.getColumns());
    }

    public SqlPara getSqlPara(String key, Model model) {
        return this.getSqlPara(key, model._getAttrs());
    }

    public SqlPara getSqlPara(String key, Map data) {
        return this.config.getSqlKit().getSqlPara(key, data);
    }

    public SqlPara getSqlPara(String key, Object ... paras) {
        return this.config.getSqlKit().getSqlPara(key, paras);
    }

    public SqlPara getSqlParaByString(String content, Map data) {
        return this.config.getSqlKit().getSqlParaByString(content, data);
    }

    public SqlPara getSqlParaByString(String content, Object ... paras) {
        return this.config.getSqlKit().getSqlParaByString(content, paras);
    }

    public List<Record> find(SqlPara sqlPara) {
        return this.find(sqlPara.getSql(), sqlPara.getPara());
    }

    public Record findFirst(SqlPara sqlPara) {
        return this.findFirst(sqlPara.getSql(), sqlPara.getPara());
    }

    public int update(SqlPara sqlPara) {
        return this.update(sqlPara.getSql(), sqlPara.getPara());
    }

    public Page<Record> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public DbTemplate template(String key, Map data) {
        return new DbTemplate(this, key, data);
    }

    public DbTemplate template(String key, Object ... paras) {
        return new DbTemplate(this, key, paras);
    }

    public DbTemplate templateByString(String content, Map data) {
        return new DbTemplate(true, this, content, data);
    }

    public DbTemplate templateByString(String content, Object ... paras) {
        return new DbTemplate(true, this, content, paras);
    }
}

