/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.template.Env;
import com.jfinal.template.io.ByteWriter;
import com.jfinal.template.io.CharWriter;
import com.jfinal.template.io.FastStringWriter;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class Template {
    private Env env;
    private Stat ast;

    public Template(Env env, Stat ast) {
        if (env == null || ast == null) {
            throw new IllegalArgumentException("env and ast can not be null");
        }
        this.env = env;
        this.ast = ast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, OutputStream outputStream) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
    }

    public void render(OutputStream outputStream) {
        this.render(null, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, Writer writer) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
    }

    public void render(Writer writer) {
        this.render(null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderToString(Map<?, ?> data) {
        try (FastStringWriter fsw = this.env.engineConfig.writerBuffer.getFastStringWriter();){
            this.render(data, fsw);
            String string = fsw.toString();
            return string;
        }
    }

    public String renderToString() {
        return this.renderToString(null);
    }

    public StringBuilder renderToStringBuilder(Map<?, ?> data) {
        FastStringWriter fsw = new FastStringWriter();
        this.render(data, fsw);
        return fsw.toStringBuilder();
    }

    public void render(Map<?, ?> data, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.render(data, fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void render(Map<?, ?> data, String fileName) {
        this.render(data, new File(fileName));
    }

    public boolean isModified() {
        return this.env.isSourceListModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderToString(Map<?, ?> data, Func<CharWriter> func) {
        try (FastStringWriter fsw = this.env.engineConfig.writerBuffer.getFastStringWriter();){
            try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(fsw);){
                func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
            }
            String string = fsw.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, OutputStream outputStream, Func<ByteWriter> func) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, Writer writer, Func<CharWriter> func) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, File file, Func<ByteWriter> func) {
        try (FileOutputStream fos = new FileOutputStream(file);
             ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(fos);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface Func<T> {
        public void call(Stat var1, Env var2, Scope var3, T var4);
    }
}

