/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.wxaapp.WxaConfigKit;
import java.util.Objects;
import java.util.function.Supplier;

public class Wxa {
    protected String appId;

    public static Wxa use(String appId) {
        Objects.requireNonNull(appId, "appId can not be null");
        return new Wxa(appId);
    }

    public static Wxa use() {
        return new Wxa(null);
    }

    Wxa(String appId) {
        this.appId = appId;
    }

    public <T> T call(Supplier<T> function) {
        if (this.appId != null) {
            try {
                WxaConfigKit.setThreadLocalAppId(this.appId);
                T t = function.get();
                return t;
            }
            finally {
                WxaConfigKit.removeThreadLocalAppId();
            }
        }
        return function.get();
    }
}

