/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.encrypt.WxaBizDataCrypt;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.kit.PaymentKit;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import com.jfinal.wxaapp.api.WxaAccessTokenApi;
import java.util.HashMap;

public class WxaUserApi {
    private static String jsCode2sessionUrl = "https://api.weixin.qq.com/sns/jscode2session";
    private static String getPaidUnionIdUrl = "https://api.weixin.qq.com/wxa/getpaidunionid";

    public static ApiResult getSessionKey(String jsCode) {
        WxaConfig wc = WxaConfigKit.getWxaConfig();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", wc.getAppId());
        params.put("secret", wc.getAppSecret());
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String para = PaymentKit.packageSign(params, false);
        String url = jsCode2sessionUrl + "?" + para;
        return new ApiResult(HttpUtils.get(url));
    }

    public static ApiResult getUserInfo(String sessionKey, String encryptedData, String ivStr) {
        WxaBizDataCrypt dataCrypt = new WxaBizDataCrypt(sessionKey);
        String json = dataCrypt.decrypt(encryptedData, ivStr);
        return new ApiResult(json);
    }

    public static boolean checkUserInfo(String sessionKey, String rawData, String signature) {
        StringBuffer sb = new StringBuffer(rawData).append(sessionKey);
        String encryData = HashKit.sha1((String)sb.toString());
        return encryData.equals(signature);
    }

    public static ApiResult getPaidUnionId(String openId, String transactionId, String mchId, String outTradeNo) {
        ParaMap paraMap = ParaMap.create().put("access_token", WxaAccessTokenApi.getAccessTokenStr()).put("openId", openId);
        if (StrKit.notBlank((String)transactionId)) {
            paraMap.put("transaction_id", transactionId);
        }
        if (StrKit.notBlank((String)mchId) && StrKit.notBlank((String)outTradeNo)) {
            paraMap.put("mch_id", mchId);
            paraMap.put("out_trade_no", outTradeNo);
        }
        String jsonResult = HttpUtils.get(getPaidUnionIdUrl, paraMap.getData());
        return new ApiResult(jsonResult);
    }
}

