/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.style.derived;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.ColorValue;
import com.openhtmltopdf.css.style.derived.FunctionValue;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.css.style.derived.ListValue;
import com.openhtmltopdf.css.style.derived.NumberValue;
import com.openhtmltopdf.css.style.derived.StringValue;
import java.util.HashMap;
import java.util.Map;

public class DerivedValueFactory {
    private static final Map CACHED_COLORS = new HashMap();

    public static FSDerivedValue newDerivedValue(CalculatedStyle style, CSSName cssName, PropertyValue value) {
        if (value.getCssValueType() == 0) {
            return style.getParent().valueByName(cssName);
        }
        switch (value.getPropertyValueType()) {
            case 2: {
                return new LengthValue(style, cssName, value);
            }
            case 4: {
                IdentValue ident = value.getIdentValue();
                if (ident == null) {
                    ident = IdentValue.getByIdentString(value.getStringValue());
                }
                return ident;
            }
            case 5: {
                return new StringValue(cssName, value);
            }
            case 1: {
                return new NumberValue(cssName, value);
            }
            case 3: {
                FSDerivedValue color = (FSDerivedValue)CACHED_COLORS.get(value.getCssText());
                if (color == null) {
                    color = new ColorValue(cssName, value);
                    CACHED_COLORS.put(value.getCssText(), color);
                }
                return color;
            }
            case 6: {
                return new ListValue(cssName, value);
            }
            case 7: {
                return new FunctionValue(cssName, value);
            }
        }
        throw new IllegalArgumentException();
    }
}

