package com.ydn.map;

import android.content.Context;
import android.content.res.AssetManager;
import android.opengl.GLSurfaceView.Renderer;
import android.os.Environment;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

/**
 * @author Feng Chen
 */
public class MapRender implements Renderer {

    static {
        System.loadLibrary("mapview");
    }

    private AssetManager assetMgr;
    private String mShopId;

    public MapRender(Context context, String shopId) {
        assetMgr = context.getAssets();
        mShopId = shopId;
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        glesInit(assetMgr, mShopId, Environment.getExternalStorageDirectory().getAbsolutePath());
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        glesResize(width, height);
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        glesRender();
    }

    /**
     * 放大缩小操作
     *
     * @param scale 缩放比例
     */
    public void zoom(float scale) {
        glesZoom(scale);
    }

    /**
     * 点击进行导航
     *
     * @param x
     * @param y
     */
    public void click(float x, float y) {
        glesClick(x, y);
    }

    /**
     * 移动地图
     *
     * @param x
     * @param y
     */
    public void move(float x, float y) {
        glesMove(x, y);
    }

    /**
     * 定位当前位置
     *
     * @param x
     * @param y
     */
    public void locate(float x, float y, float angle) {
        glesLocate(x, y, angle);
    }

    public void mark(String ids) {
        glesMark(ids);
    }

    public void floor(int floorNo) {
        glesFloor(floorNo);
    }

    public void nav(String id) {
        glesNav(id);
    }

    private native void glesInit(AssetManager assetMgr, String shopId, String dist);

    private native void glesResize(int width, int height);

    private native void glesRender();

    private native void glesClick(float x, float y);

    private native void glesLocate(float x, float y, float angle);

    private native void glesMark(String ids);

    private native void glesZoom(float scale);

    private native void glesMove(float x, float y);

    private native void glesFloor(int floor);

    private native void glesNav(String id);

}
