package com.ydn.simpleserial;

import com.ydn.simpleserial.adapter.SerialAdapter;
import com.ydn.simpleserial.adapter.SerialAdapterFactory;
import com.ydn.simpleserial.configuration.SerialConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Feng Chen
 */
public class SimpleSerial {

    private SerialAdapter serialAdapter;

    private static final Logger logger = LoggerFactory.getLogger(SimpleSerial.class);

    public SimpleSerial(SerialConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null");
        }
        this.serialAdapter = SerialAdapterFactory.createSerialAdapter(configuration);
    }

    /**
     * 获取流水号
     *
     * @return
     * @throws Exception
     */
    public int get() throws Exception {
        return serialAdapter.get();
    }

    /**
     * 获取流水号
     *
     * @param key
     * @return
     * @throws Exception
     */
    public int get(String key) throws Exception {
        return serialAdapter.get(key);
    }


    /**
     * 开启服务
     *
     * @throws Exception
     */
    public void start() throws Exception {
        serialAdapter.start();
    }

    /**
     * 关闭服务
     *
     * @throws Exception
     */
    public void close() throws Exception {
        serialAdapter.close();
    }

}
