package com.ydn.simpleserial.adapter;

import com.ydn.simpleserial.configuration.SerialConfiguration;
import com.ydn.simpleserial.configuration.ZkSerialConfiguration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class SerialAdapterFactory {

    private final static Map<Class<? extends SerialConfiguration>, SerialAdapterCreator> CREATOR_MAP
            = new HashMap<Class<? extends SerialConfiguration>, SerialAdapterCreator>();

    static {
        CREATOR_MAP.put(ZkSerialConfiguration.class, new ZkSerialAdapterCreator());
    }

    public static SerialAdapter createSerialAdapter(SerialConfiguration configuration) {
        Class cacheConfigType;
        boolean isCompatibleType;
        Iterator it = CREATOR_MAP.keySet().iterator();
        do {
            if (!it.hasNext()) {
                throw new IllegalArgumentException("Unrecognized configuration type: " + configuration.getClass());
            }

            cacheConfigType = (Class) it.next();
            isCompatibleType = cacheConfigType.isAssignableFrom(configuration.getClass());
        } while (!isCompatibleType);

        return CREATOR_MAP.get(configuration.getClass()).create(configuration);
    }

    private static class ZkSerialAdapterCreator implements SerialAdapterCreator<ZkSerialConfiguration> {
        @Override
        public ZkSerialAdapter create(ZkSerialConfiguration configuration) {
            return new ZkSerialAdapter(configuration);
        }
    }


    ////////////////////////////////////

    private static interface SerialAdapterCreator<T extends SerialConfiguration> {
        public ZkSerialAdapter create(T configuration);
    }

}
