package com.ydn.simpleserial.configuration;

/**
 * @author Feng Chen
 */
public class ZkSerialConfiguration implements SerialConfiguration {

    private String namespace = DEFAULT_NAMESPACE;
    private String zkHosts;
    private int baseSleepTimeMs = DEFAULT_BASE_SLEEP_TIME_MS;
    private int maxRetries = DEFAULT_MAX_RETRIES;
    private int sessionTimeoutMs = DEFAULT_SESSION_TIMEOUT_MS;
    private int connectionTimeoutMs = DEFAULT_CONNECTION_TIMEOUT_MS;
    private int maxValue = Integer.MAX_VALUE;
    private int maxWait = DEFAULT_MAX_WAIT_MS;

    private static final String DEFAULT_NAMESPACE = "simpleserial";
    private static final int DEFAULT_SESSION_TIMEOUT_MS = 60 * 1000;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 15 * 1000;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_BASE_SLEEP_TIME_MS = 1000;
    private static final int DEFAULT_MAX_WAIT_MS = 6 * 1000;

    public ZkSerialConfiguration(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public ZkSerialConfiguration(String namespace, String zkHosts) {
        this.namespace = namespace;
        this.zkHosts = zkHosts;
    }

    public ZkSerialConfiguration(String namespace, String zkHosts, int sessionTimeoutMs, int connectionTimeoutMs) {
        this.namespace = namespace;
        this.zkHosts = zkHosts;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public ZkSerialConfiguration(String namespace, String zkHosts, int baseSleepTimeMs, int maxRetries, int sessionTimeoutMs, int connectionTimeoutMs) {
        this.namespace = namespace;
        this.zkHosts = zkHosts;
        this.baseSleepTimeMs = baseSleepTimeMs;
        this.maxRetries = maxRetries;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getZkHosts() {
        return zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public int getBaseSleepTimeMs() {
        return baseSleepTimeMs;
    }

    public void setBaseSleepTimeMs(int baseSleepTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    public int getMaxRetries() {
        return maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getSessionTimeoutMs() {
        return sessionTimeoutMs;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public int getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxWait() {
        return maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }
}
