/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simpleserial.adapter;

import com.ydn.simpleserial.adapter.SerialAdapter;
import com.ydn.simpleserial.adapter.ZkSerialAdapter;
import com.ydn.simpleserial.configuration.SerialConfiguration;
import com.ydn.simpleserial.configuration.ZkSerialConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerialAdapterFactory {
    private static final Map<Class<? extends SerialConfiguration>, SerialAdapterCreator> CREATOR_MAP = new HashMap<Class<? extends SerialConfiguration>, SerialAdapterCreator>();

    public static SerialAdapter createSerialAdapter(SerialConfiguration configuration) {
        Class<? extends SerialConfiguration> cacheConfigType;
        boolean isCompatibleType;
        Iterator<Class<? extends SerialConfiguration>> it = CREATOR_MAP.keySet().iterator();
        do {
            if (it.hasNext()) continue;
            throw new IllegalArgumentException("Unrecognized configuration type: " + configuration.getClass());
        } while (!(isCompatibleType = (cacheConfigType = it.next()).isAssignableFrom(configuration.getClass())));
        return CREATOR_MAP.get(configuration.getClass()).create(configuration);
    }

    static {
        CREATOR_MAP.put(ZkSerialConfiguration.class, new ZkSerialAdapterCreator());
    }

    private static interface SerialAdapterCreator<T extends SerialConfiguration> {
        public ZkSerialAdapter create(T var1);
    }

    private static class ZkSerialAdapterCreator
    implements SerialAdapterCreator<ZkSerialConfiguration> {
        private ZkSerialAdapterCreator() {
        }

        @Override
        public ZkSerialAdapter create(ZkSerialConfiguration configuration) {
            return new ZkSerialAdapter(configuration);
        }
    }
}

