/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.simpleserial.adapter;

import com.ydn.simpleserial.adapter.SerialAdapter;
import com.ydn.simpleserial.configuration.ZkSerialConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZkSerialAdapter
implements SerialAdapter {
    private ZkSerialConfiguration configuration;
    private CuratorFramework curator;

    public ZkSerialAdapter(ZkSerialConfiguration configuration) {
        this.configuration = configuration;
        this.initCurator();
    }

    @Override
    public int get() throws Exception {
        return this.getAndIncrement(null);
    }

    @Override
    public int get(String key) throws Exception {
        return this.getAndIncrement(key);
    }

    @Override
    public void start() throws Exception {
        this.curator.start();
    }

    @Override
    public void close() throws Exception {
        if (this.curator != null) {
            this.curator.close();
        }
    }

    private void initCurator() {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.configuration.getBaseSleepTimeMs(), this.configuration.getMaxRetries());
        this.curator = CuratorFrameworkFactory.newClient((String)this.configuration.getZkHosts(), (int)this.configuration.getSessionTimeoutMs(), (int)this.configuration.getConnectionTimeoutMs(), (RetryPolicy)retryPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndIncrement(String key) throws Exception {
        int value = 0;
        InterProcessLock lock = this.getLock(key);
        String path = this.getPath(key);
        try {
            byte[] bytes;
            if (!lock.acquire((long)this.configuration.getMaxWait(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Could not acquire the lock");
            }
            try {
                bytes = (byte[])this.curator.getData().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                this.mkdir(path);
                bytes = (byte[])this.curator.getData().forPath(path);
            }
            if (bytes != null && (value = Integer.parseInt(new String(bytes))) > this.configuration.getMaxValue()) {
                value = 1;
            }
            this.curator.setData().forPath(path, String.valueOf(value + 1).getBytes());
        }
        finally {
            lock.release();
        }
        return value;
    }

    private void mkdir(String path) {
        try {
            if (this.curator.checkExists().forPath(path) == null) {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, "1".getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InterProcessLock getLock(String key) {
        InterProcessMutex lock = key != null ? new InterProcessMutex(this.curator, String.format("/simpleserial/%s/%s/lock", this.configuration.getNamespace(), key)) : new InterProcessMutex(this.curator, String.format("/simpleserial/%s/lock", this.configuration.getNamespace()));
        return lock;
    }

    private String getPath(String key) {
        String path = key != null ? String.format("/simpleserial/%s/%s/serial", this.configuration.getNamespace(), key) : String.format("/simpleserial/%s/serial", this.configuration.getNamespace());
        return path;
    }
}

