package com.ydn.web.appserver;

import com.ydn.web.appserver.core.ActionContext;
import com.ydn.web.appserver.core.AppServerCore;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 接口定义
 *
 * @author Feng Chen
 */
public abstract class AbstractController {

    // request / response

    public HttpServletRequest getRequest() {
        return ActionContext.getContext().getRequest();
    }

    public HttpServletResponse getResponse() {
        return ActionContext.getContext().getResponse();
    }

    // render

    public void renderJson(Result result) {
        AppServerCore.inst()
                .getRenderFactory()
                .getJsonRender(result)
                .setContext(ActionContext.getContext().getRequest(), ActionContext.getContext().getResponse())
                .render();
    }

    // param

    public String getString(String key) {
        return ActionContext.getContext().getParam(key);
    }

    public Integer getInt(String key) {
        return getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public Long getLong(String key) {
        return getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    // oookie

    public String getCookie(String name) {
        return getCookie(name, null);
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = getRequest().getCookies();
        if (cookies != null)
            for (Cookie cookie : cookies)
                if (cookie.getName().equals(name))
                    return cookie;
        return null;
    }

    public void removeCookie(String name) {
        doSetCookie(name, null, 0, null, null, null);
    }

    // SECTION : INNER HELPER

    private void doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        // set the default path value to "/"
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);

        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly);
        }
        getResponse().addCookie(cookie);
    }

}
