package com.ydn.web.appserver;

import com.ydn.web.appserver.core.AppServerCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author Feng Chen
 */
public class DispatchFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(DispatchFilter.class);

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;

        try {
            if (request.getRequestURI().indexOf(".") == -1) {
                AppServerCore.inst().process(request, response);
            } else {
                chain.doFilter(req, res);
            }
        } catch (Exception e) {
            logger.error("", e);
        }

    }
}
