package com.ydn.web.appserver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class Result extends HashMap<String, Object> {

    // 成功标识
    public static final int SUCCESSCODE = 0;

    // 系统错误
    public static final int ERRORCODE = 500;

    // 返回编码
    public final static String ERRCODE = "errcode";

    // 返回消息
    public final static String ERRMSG = "errmsg";

    public Result() {
        put(ERRCODE, 0);
        put(ERRMSG, "");
    }

    /**
     * 异常
     *
     * @return
     */
    public static Result error() {
        return error(ERRORCODE, "系统错误");
    }

    /**
     * @param code
     * @param message
     * @return
     */
    public static Result error(int code, String message) {
        Result result = new Result();
        result.put(ERRCODE, code);
        result.put(ERRMSG, message);
        return result;
    }

    public static Result success() {
        return new Result();
    }

    public static Result success(List list) {
        Result result = new Result();
        result.put("list", list);
        return result;
    }

    public static Result success(Object object) {
        Result result = new Result();
        result.put("data", object);
        return result;
    }

    public static Result success(Map map) {
        Result result = new Result();
        result.put("data", map);
        return result;
    }

    public static Result success(List list, int count) {
        Result result = new Result();
        result.put("list", list);
        result.put("count", count);
        return result;
    }

    public static Result success(List list, int total, int count) {
        Result result = new Result();
        result.put("list", list);
        result.put("total", total);
        result.put("count", count);
        return result;
    }

    public Result put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public Result putData(String key, Object value) {
        if (!this.containsKey("data")) {
            this.put("data", new HashMap<String, Object>());
        }
        Map<String, Object> data = (Map<String, Object>) this.get("data");
        data.put(key, value);
        return this;
    }

}
