package com.ydn.web.appserver.core;


import com.ydn.web.appserver.Interceptor;

/**
 * @author Feng Chen
 */
public class ActionInvocation {

    private InterceptorChain interceptors;

    private ActionContext actionContext;

    private FinalInvocation finalInvocation;

    public ActionInvocation(
            InterceptorChain interceptors,
            ActionContext actionContext,
            FinalInvocation finalInvocation
    ) {
        this.interceptors = interceptors;
        this.actionContext = actionContext;
        this.finalInvocation = finalInvocation;
    }

    // 真正执行 action
    public void invoke() throws Exception {
        Interceptor next = interceptors.next();
        if (next != null) {
            next.intercept(this);
        } else {
            try {
                actionContext.setStartMillis(System.currentTimeMillis());
                finalInvocation.invoke();
            } finally {
                actionContext.setEndMillis(System.currentTimeMillis());
            }
        }
    }

    public InterceptorChain getInterceptors() {
        return interceptors;
    }

    public ActionContext getActionContext() {
        return actionContext;
    }

    ///////////////////////////////////////////////

    public static interface FinalInvocation {

        void invoke() throws Exception;

    }

}
