package com.ydn.web.appserver.core;

/**
 * 记录单个 Action 的执行统计信息
 *
 * @author Feng Chen
 */
public class ActionStat {

    /**
     * Action 名称
     */
    private String name;

    /**
     * Action 描述
     */
    private String desc;

    /**
     * 执行总时长
     */
    private Long totalCst = 0L;

    /**
     * 执行总次数
     */
    private Long totalCnt = 0L;

    /**
     * 成功次数
     */
    private Long succCnt = 0L;

    /**
     * 失败次数
     */
    private Long failCnt = 0L;

    public ActionStat() {

    }

    public ActionStat(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    /**
     * 添加成功统计信息
     */
    public void succ(long elapse) {
        totalCnt++;
        succCnt++;
        totalCst += elapse;
    }

    /**
     * 添加失败统计信息
     */
    public void fail(long elapse, Exception e) {
        totalCnt++;
        failCnt++;
        totalCst += elapse;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Long getTotalCst() {
        return totalCst;
    }

    public void setTotalCst(Long totalCst) {
        this.totalCst = totalCst;
    }

    public Long getTotalCnt() {
        return totalCnt;
    }

    public void setTotalCnt(Long totalCnt) {
        this.totalCnt = totalCnt;
    }

    public Long getSuccCnt() {
        return succCnt;
    }

    public void setSuccCnt(Long succCnt) {
        this.succCnt = succCnt;
    }

    public Long getFailCnt() {
        return failCnt;
    }

    public void setFailCnt(Long failCnt) {
        this.failCnt = failCnt;
    }
}
