package com.ydn.web.appserver.core;

import com.ydn.web.appserver.AbstractController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Feng Chen
 */
public class DefaultControllerFactory implements ControllerFactory {

    private static final Logger logger = LoggerFactory.getLogger(DefaultControllerFactory.class);

    @Override
    public AbstractController getController(Class<? extends AbstractController> type) {
        try {
            return type.newInstance();
        } catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }
}
