package com.ydn.web.appserver.core;

import com.ydn.web.appserver.Interceptor;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class DefaultInterceptorFactory implements InterceptorFactory {

    private static Map<String, Interceptor> repos = new HashMap<>();

    @Override
    public void addInterceptor(Interceptor interceptor) {
        if (!repos.containsKey(interceptor.code())) {
            repos.put(interceptor.code(), interceptor);
        }
    }

    @Override
    public InterceptorChain getInterceptors(String... codes) {
        InterceptorChain chain = new InterceptorChain();
        for (String code : codes) {
            chain.add(repos.get(code));
        }
        return chain;
    }

}
