package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.core.ConsoleHandler;
import com.ydn.web.appserver.util.JwtUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class AdminLoginHandler extends ConsoleHandler {

    private static final Logger logger = LoggerFactory.getLogger(AdminLoginHandler.class);


    @Override
    protected void doHandle() {
        String user = getString("user");
        String pwd = getString("pwd");
        if (getAdminUser().equals(user) && getAdminPwd().equals(pwd)) {
            setCookie("at", at(user), JWT_EXPIRE, true);
            renderJson(Result.success());
        } else {
            renderJson(Result.error(401, "账号或密码错误"));
        }
    }


    private String at(String user) {
        try {
            Map<String, Object> param = new HashMap<>();
            param.put("user", user);
            return JwtUtil.newToken(param, JWT_SECRET, JWT_EXPIRE.longValue());
        } catch (Exception e) {
            logger.error("", e);
        }
        return null;
    }

}
