package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.ConsoleHandler;
import com.ydn.web.appserver.core.PrefStat;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 性能统计
 *
 * @author Feng Chen
 */
public class PerfStatHandler extends ConsoleHandler {

    private static final int PAGE_SIZE = 10;

    @Override
    protected void doHandle() {

        if (!checkAt()) {
            renderRedirect("_console/login");
        }

        int pageNo = getInt("pageNo");
        List<PrefStat> stats = AppServerCore.inst()
                .getServerStat()
                .getPrefStats();

        int totalPage = (int) Math.ceil(stats.size() * 1.0 / PAGE_SIZE);

        List<PrefStat> list = stats.stream().sorted()
                .skip(pageNo * PAGE_SIZE)
                .limit(PAGE_SIZE)
                .collect(Collectors.toList());

        renderJson(Result.success()
                .putData("list", list)
                .putData("totalPage", totalPage)
                .putData("currPage", pageNo)
        );
    }

}
