package com.ydn.web.appserver.core.dispatch;

import com.ydn.web.appserver.core.Dispatcher;
import com.ydn.web.appserver.core.console.ConsoleHandlers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 控制台
 *
 * @author Feng Chen
 */
public class ConsoleDispatcher implements Dispatcher {

    private static final Logger logger = LoggerFactory.getLogger(ConsoleDispatcher.class);

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getRequestURI().indexOf("_console") != -1) {

            // 控制台页面访问
            ConsoleHandlers.inst().handle(request, response);
        }
    }

}
