package com.ydn.web.appserver.render;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class ErrorRender extends Render {

    protected int errorCode;

    protected static final String contentType = "text/html; charset=" + encoding;

    protected static final String version = "<center>请求异常</center>";

    protected static final byte[] html404 = ("<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr>" + version + "</body></html>").getBytes();
    protected static final byte[] html500 = ("<html><head><title>系统异常</title></head><body bgcolor='white'><center><h1>系统异常</h1></center></body></html>").getBytes();

    protected static final byte[] html400 = ("<html><head><title>400 Bad Request</title></head><body bgcolor='white'><center><h1>400 Bad Request</h1></center><hr>" + version + "</body></html>").getBytes();
    protected static final byte[] html401 = ("<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr>" + version + "</body></html>").getBytes();
    protected static final byte[] html403 = ("<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr>" + version + "</body></html>").getBytes();

    public ErrorRender(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public void render() {
        response.setStatus(errorCode);
        try {
            response.setContentType(contentType);
            response.getOutputStream().write(getErrorHtml());

        } catch (IOException e) {
            throw new RenderException(e);
        }
    }

    private byte[] getErrorHtml() {
        int errorCode = getErrorCode();
        if (errorCode == 404)
            return html404;
        if (errorCode == 500)
            return html500;
        if (errorCode == 400)
            return html400;
        if (errorCode == 401)
            return html401;
        if (errorCode == 403)
            return html403;
        return ("<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + version + "</body></html>").getBytes();
    }

    private int getErrorCode() {
        return errorCode;
    }

}
