package com.ydn.web.appserver.render;

import com.ydn.web.appserver.core.AppServerCore;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class RedirectRender extends Render {

    private String url;

    public RedirectRender(String url) {
        this.url = url;
    }

    @Override
    public void render() {
        try {
            response.sendRedirect(redirect());
        } catch (IOException e) {
            throw new RenderException(e);
        }
    }

    // SECTION : INNER HELPER

    private String redirect() {
        String redirect;
        if (!url.matches("^http://(.)*|^https://(.)*")) {
            redirect = contextPath() + "/" + url;
        } else {
            redirect = url;
        }
        return redirect;
    }

    private String contextPath() {
        String path = AppServerCore.inst().getServerConfiguration().getContextPath();
        return path.startsWith("/") ? path : "/" + path;
    }

}
