package com.ydn.web.appserver.render;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class StringRender extends Render {

    private static final String contentType = "application/json; charset=" + encoding;
    private String text;

    public StringRender(String text) {
        this.text = text;
    }

    @Override
    public void render() {
        try {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0);

            response.setContentType(contentType);
            response.getWriter().write(text);
        } catch (IOException e) {
            throw new RenderException(e);
        }
    }
}
