package com.ydn.web.appserver.spring;

import com.ydn.web.appserver.AbstractController;
import com.ydn.web.appserver.core.ControllerFactory;
import org.springframework.context.ApplicationContext;

/**
 * @author Feng Chen
 */
public class SpringControllerFactory implements ControllerFactory {

    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public AbstractController getController(Class<? extends AbstractController> type) {
        return applicationContext.getBean(type);
    }

}
