package com.ydn.web.controller;

import com.ydn.web.appserver.AbstractController;
import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.annotation.Error;
import com.ydn.web.appserver.annotation.*;

/**
 * @author Feng Chen
 */
@Controller(value = "/dev", desc = "开发")
public class DevController extends AbstractController {

    @RequestMapping(
            value = "/echo1",
            desc = "开发接口1",
            method = RequestMethod.ALL,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "sheet", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "sheet",
                            props = {
                                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果3")
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo1() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

    @RequestMapping(
            value = "/echo2",
            desc = "开发接口2",
            method = RequestMethod.GET,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "sheet", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "sheet",
                            props = {
                                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果3")
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo2() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

    @RequestMapping(
            value = "/echo3",
            desc = "开发接口3",
            method = RequestMethod.POST,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "sheet", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "sheet",
                            props = {
                                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果3")
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo3() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

    @RequestMapping(
            value = "/echo4",
            desc = "开发接口4",
            method = RequestMethod.ALL,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "sheet", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "sheet",
                            props = {
                                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果3")
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo4() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

    @RequestMapping(
            value = "/echo5",
            desc = "开发接口5",
            method = RequestMethod.GET,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "sheet", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "sheet",
                            props = {
                                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果3")
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo5() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

    @RequestMapping(
            value = "/echo6",
            desc = "开发接口6",
            method = RequestMethod.GET,
            request = {
                    @Parameter(name = "r1", type = ParamType.STRING, desc = "参数1", required = true),
                    @Parameter(name = "r2", type = ParamType.STRING, desc = "参数2", required = true),
            },
            response = {
                    @Property(name = "p1", type = PropType.STRING, desc = "结果1"),
                    @Property(name = "p2", type = PropType.STRING, desc = "结果2"),
                    @Property(name = "p3", type = PropType.STRING, desc = "结果3"),
                    @Property(name = "data", type = PropType.SHEET, desc = "结果4", sheet = "sheet"),
            },
            sheets = {
                    @Sheet(
                            name = "data",
                            props = {
                                    @Property(name = "p1", type = PropType.INTEGER, desc = "结果1"),
                                    @Property(name = "p2", type = PropType.DECIMAL, desc = "结果2"),
                                    @Property(name = "p3", type = PropType.DATE, desc = "结果3"),
                                    @Property(name = "p3", type = PropType.STRING, desc = "结果4"),
                            }
                    )
            },
            errors = {
                    @Error(code = "404", cause = "资源未找到")
            }
    )
    public void echo6() {
        String r1 = getString("r1");
        String r2 = getString("r2");
        System.out.println(r1);
        System.out.println(r2);
        renderJson(Result.success());
    }

}
