/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver;

import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.core.ActionContext;
import com.ydn.web.appserver.core.AppServerCore;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractController {
    public HttpServletRequest getRequest() {
        return ActionContext.getContext().getRequest();
    }

    public HttpServletResponse getResponse() {
        return ActionContext.getContext().getResponse();
    }

    public void renderJson(Result result) {
        AppServerCore.inst().getRenderFactory().getJsonRender(result).setContext(ActionContext.getContext().getRequest(), ActionContext.getContext().getResponse()).render();
    }

    public String getString(String key) {
        return ActionContext.getContext().getParam(key);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = ActionContext.getContext().getParam(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void removeCookie(String name) {
        this.doSetCookie(name, null, 0, null, null, null);
    }

    private void doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly.booleanValue());
        }
        this.getResponse().addCookie(cookie);
    }
}

