/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver;

import com.ydn.web.appserver.WebAppServer;
import com.ydn.web.appserver.core.AppServerFactory;
import com.ydn.web.appserver.core.ServerConfiguration;
import com.ydn.web.appserver.util.Arguments;
import com.ydn.web.appserver.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DefaultServerMain {
    private static WebAppServer defaultServer = null;

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments(args);
        defaultServer = DefaultServerMain.createDefaultServer(arguments, "/server.properties");
        defaultServer.start();
    }

    private static WebAppServer createDefaultServer(Arguments arguments, String property) throws IOException {
        Properties properties = DefaultServerMain.combineArgumentsAndProperties(arguments, property);
        return AppServerFactory.createServer(properties);
    }

    private static Properties combineArgumentsAndProperties(Arguments arguments, String property) throws IOException {
        InputStream stream;
        String confPath = arguments.getString("conf");
        Properties properties = StringUtil.isNotEmpty(confPath) ? DefaultServerMain.readPropertyFile(confPath) : ((stream = DefaultServerMain.class.getResourceAsStream(property)) != null ? DefaultServerMain.readPropertyStream(stream) : new Properties());
        String ip = arguments.getString("ip", properties.getProperty("ip", "0.0.0.0"));
        int port = arguments.getInteger("port", Integer.parseInt(properties.getProperty("port", String.valueOf(8080))));
        int maxActiveWorkers = arguments.getInteger("max-active-workers", Integer.parseInt(properties.getProperty("max-active-workers", String.valueOf(ServerConfiguration.DEFAULT_MAX_PROCESSORS))));
        properties.put("ip", ip);
        properties.put("port", (Object)port);
        properties.put("max-active-workers", (Object)maxActiveWorkers);
        return properties;
    }

    private static Properties readPropertyFile(String confPath) throws IOException {
        try (FileInputStream stream = new FileInputStream(confPath);){
            Properties properties = DefaultServerMain.readPropertyStream(stream);
            return properties;
        }
    }

    private static Properties readPropertyStream(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        return properties;
    }
}

