/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver;

import com.ydn.web.appserver.AppServerException;
import com.ydn.web.appserver.ContextListener;
import com.ydn.web.appserver.DispatchFilter;
import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.CompositeResourceManager;
import com.ydn.web.appserver.core.ControllerFactory;
import com.ydn.web.appserver.core.ServerConfiguration;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppServer {
    private ServerConfiguration configuration;
    private ContextListener contextListener;
    private boolean started = false;
    private Undertow undertow;
    private DeploymentInfo deploymentInfo;
    private DeploymentManager deploymentManager;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final Logger logger = LoggerFactory.getLogger(WebAppServer.class);

    public WebAppServer(String contextPath, int port) {
        this.configuration = new ServerConfiguration();
        this.configuration.setContextPath(contextPath);
        this.configuration.setPort(port);
        AppServerCore.inst().setServerConfiguration(this.configuration);
        this.setupCoreInterceptors();
    }

    public WebAppServer(String contextPath, String ip, int port, int threads) {
        this.configuration = new ServerConfiguration();
        this.configuration.setContextPath(contextPath);
        this.configuration.setIp(ip);
        this.configuration.setPort(port);
        this.configuration.setIoThread(threads);
        this.configuration.setWorkThread(threads * 2);
        AppServerCore.inst().setServerConfiguration(this.configuration);
        this.setupCoreInterceptors();
    }

    public void setAdminUser(String username) {
        this.configuration.setAdminUser(username);
    }

    public void setAdminPwd(String password) {
        this.configuration.setAdminPwd(password);
    }

    public void setPackages(String ... packages) {
        AppServerCore.inst().setPackages(packages);
    }

    public void setControllerFactory(ControllerFactory controllerFactory) {
        AppServerCore.inst().setControllerFactory(controllerFactory);
    }

    public void addInterceptor(Interceptor interceptor) {
        AppServerCore.inst().addInterceptor(interceptor);
    }

    public void setContextListener(ContextListener contextListener) {
        this.contextListener = contextListener;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public <T> T getProperty(String name) {
        return (T)this.properties.get(name);
    }

    public void start() {
        if (this.started) {
            logger.info("Already Started..");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebAppServer.this.stop();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }));
        try {
            this.configUndertow();
            this.undertow.start();
            if (this.contextListener != null) {
                this.contextListener.initialize(this.configuration);
            }
            this.started = true;
            logger.info("Web App Server Started Successfully. Server status : http://[server]:" + this.configuration.getPort() + "/" + this.configuration.getContextPath());
        }
        catch (ServletException e) {
            logger.error("", (Throwable)e);
            throw new AppServerException(e);
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (this.contextListener != null) {
                this.contextListener.destory(this.configuration);
            }
            this.deploymentManager.stop();
            this.undertow.stop();
            this.started = false;
            logger.info("Web App Server Closed Successfully. Good Bye.\n\n");
        }
        catch (ServletException e) {
            throw new AppServerException(e);
        }
    }

    private void configUndertow() throws ServletException {
        this.deploymentInfo = Servlets.deployment();
        this.deploymentInfo.setClassLoader(WebAppServer.class.getClassLoader());
        this.deploymentInfo.setResourceManager((ResourceManager)new CompositeResourceManager("src/main/webapp", "classpath:web"));
        this.deploymentInfo.setDeploymentName(this.configuration.getContextPath());
        this.deploymentInfo.setContextPath(this.configuration.getContextPath());
        this.deploymentInfo.setEagerFilterInit(true);
        this.deploymentInfo.addFilter(Servlets.filter((String)"dispatch", DispatchFilter.class)).addFilterUrlMapping("dispatch", "/*", DispatcherType.REQUEST);
        this.deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        this.deploymentManager.deploy();
        HttpHandler httpHandler = this.deploymentManager.start();
        this.undertow = Undertow.builder().setIoThreads(this.configuration.getIoThread()).setWorkerThreads(this.configuration.getWorkThread()).addHttpListener(this.configuration.getPort(), this.configuration.getIp()).setHandler((HttpHandler)Handlers.path().addPrefixPath(this.configuration.getContextPath(), httpHandler)).build();
    }

    private void setupCoreInterceptors() {
    }
}

